/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class EmbeddedTransactionHeaderBuilder
implements Serializer {
    private int size;
    private final int embeddedTransactionHeader_Reserved1;

    protected EmbeddedTransactionHeaderBuilder(DataInputStream stream) {
        try {
            this.size = Integer.reverseBytes(stream.readInt());
            this.embeddedTransactionHeader_Reserved1 = Integer.reverseBytes(stream.readInt());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedTransactionHeaderBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedTransactionHeaderBuilder(stream);
    }

    protected EmbeddedTransactionHeaderBuilder() {
        this.embeddedTransactionHeader_Reserved1 = 0;
    }

    public static EmbeddedTransactionHeaderBuilder create() {
        return new EmbeddedTransactionHeaderBuilder();
    }

    public int getStreamSize() {
        return this.size;
    }

    public int getEmbeddedTransactionHeader_Reserved1() {
        return this.embeddedTransactionHeader_Reserved1;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        return size += 4;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getSize()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getEmbeddedTransactionHeader_Reserved1()));
        });
    }
}

