/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountKeyLinkTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class EmbeddedAccountKeyLinkTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final AccountKeyLinkTransactionBodyBuilder accountKeyLinkTransactionBody;

    protected EmbeddedAccountKeyLinkTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.accountKeyLinkTransactionBody = AccountKeyLinkTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedAccountKeyLinkTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedAccountKeyLinkTransactionBuilder(stream);
    }

    protected EmbeddedAccountKeyLinkTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto remotePublicKey, LinkActionDto linkAction) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(remotePublicKey, "remotePublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.accountKeyLinkTransactionBody = new AccountKeyLinkTransactionBodyBuilder(remotePublicKey, linkAction);
    }

    public static EmbeddedAccountKeyLinkTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto remotePublicKey, LinkActionDto linkAction) {
        return new EmbeddedAccountKeyLinkTransactionBuilder(signerPublicKey, version, network, type, remotePublicKey, linkAction);
    }

    public KeyDto getRemotePublicKey() {
        return this.accountKeyLinkTransactionBody.getRemotePublicKey();
    }

    public LinkActionDto getLinkAction() {
        return this.accountKeyLinkTransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.accountKeyLinkTransactionBody.getSize();
    }

    @Override
    public AccountKeyLinkTransactionBodyBuilder getBody() {
        return this.accountKeyLinkTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.accountKeyLinkTransactionBody);
        });
    }
}

