/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.CosignatureBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import java.io.DataInputStream;

public class DetachedCosignatureBuilder
extends CosignatureBuilder
implements Serializer {
    private final Hash256Dto parentHash;

    protected DetachedCosignatureBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.parentHash = Hash256Dto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static DetachedCosignatureBuilder loadFromBinary(DataInputStream stream) {
        return new DetachedCosignatureBuilder(stream);
    }

    protected DetachedCosignatureBuilder(KeyDto signerPublicKey, SignatureDto signature, Hash256Dto parentHash) {
        super(signerPublicKey, signature);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(parentHash, "parentHash is null", new Object[0]);
        this.parentHash = parentHash;
    }

    public static DetachedCosignatureBuilder create(KeyDto signerPublicKey, SignatureDto signature, Hash256Dto parentHash) {
        return new DetachedCosignatureBuilder(signerPublicKey, signature, parentHash);
    }

    public Hash256Dto getParentHash() {
        return this.parentHash;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.parentHash.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.parentHash);
        });
    }
}

