/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class AddressDto
implements Serializer {
    private final ByteBuffer address;

    public AddressDto(ByteBuffer address) {
        this.address = address;
    }

    public AddressDto(DataInputStream stream) {
        try {
            this.address = GeneratorUtils.readByteBuffer(stream, 25);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getAddress() {
        return this.address;
    }

    @Override
    public int getSize() {
        return 25;
    }

    public static AddressDto loadFromBinary(DataInputStream stream) {
        return new AddressDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.address.array(), 0, this.address.array().length));
    }
}

