/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountKeyFlagsDto;
import io.nem.symbol.catapult.builders.AccountStateFormatDto;
import io.nem.symbol.catapult.builders.AccountTypeDto;
import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.HeightActivityBucketsBuilder;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.ImportanceSnapshotBuilder;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.VotingKeyDto;
import java.io.DataInputStream;
import java.util.EnumSet;
import java.util.List;

public class AccountStateBuilder
implements Serializer {
    private final AddressDto address;
    private final HeightDto addressHeight;
    private final KeyDto publicKey;
    private final HeightDto publicKeyHeight;
    private final AccountTypeDto accountType;
    private final AccountStateFormatDto format;
    private final EnumSet<AccountKeyFlagsDto> supplementalAccountKeysMask;
    private KeyDto linkedPublicKey;
    private KeyDto vrfPublicKey;
    private VotingKeyDto votingPublicKey;
    private KeyDto nodePublicKey;
    private ImportanceSnapshotBuilder importanceSnapshots;
    private HeightActivityBucketsBuilder activityBuckets;
    private final MosaicIdDto currencyMosaicId;
    private final List<MosaicBuilder> balances;

    protected AccountStateBuilder(DataInputStream stream) {
        try {
            this.address = AddressDto.loadFromBinary(stream);
            this.addressHeight = HeightDto.loadFromBinary(stream);
            this.publicKey = KeyDto.loadFromBinary(stream);
            this.publicKeyHeight = HeightDto.loadFromBinary(stream);
            this.accountType = AccountTypeDto.loadFromBinary(stream);
            this.format = AccountStateFormatDto.loadFromBinary(stream);
            this.supplementalAccountKeysMask = GeneratorUtils.toSet(AccountKeyFlagsDto.class, stream.readByte());
            this.currencyMosaicId = MosaicIdDto.loadFromBinary(stream);
            short balancesCount = Short.reverseBytes(stream.readShort());
            this.balances = GeneratorUtils.loadFromBinaryArray(MosaicBuilder::loadFromBinary, stream, balancesCount);
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.LINKED)) {
                this.linkedPublicKey = KeyDto.loadFromBinary(stream);
            }
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VRF)) {
                this.vrfPublicKey = KeyDto.loadFromBinary(stream);
            }
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VOTING)) {
                this.votingPublicKey = VotingKeyDto.loadFromBinary(stream);
            }
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.NODE)) {
                this.nodePublicKey = KeyDto.loadFromBinary(stream);
            }
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                this.importanceSnapshots = ImportanceSnapshotBuilder.loadFromBinary(stream);
            }
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                this.activityBuckets = HeightActivityBucketsBuilder.loadFromBinary(stream);
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountStateBuilder loadFromBinary(DataInputStream stream) {
        return new AccountStateBuilder(stream);
    }

    protected AccountStateBuilder(AddressDto address, HeightDto addressHeight, KeyDto publicKey, HeightDto publicKeyHeight, AccountTypeDto accountType, AccountStateFormatDto format, EnumSet<AccountKeyFlagsDto> supplementalAccountKeysMask, KeyDto linkedPublicKey, KeyDto vrfPublicKey, VotingKeyDto votingPublicKey, KeyDto nodePublicKey, ImportanceSnapshotBuilder importanceSnapshots, HeightActivityBucketsBuilder activityBuckets, MosaicIdDto currencyMosaicId, List<MosaicBuilder> balances) {
        GeneratorUtils.notNull(address, "address is null", new Object[0]);
        GeneratorUtils.notNull(addressHeight, "addressHeight is null", new Object[0]);
        GeneratorUtils.notNull(publicKey, "publicKey is null", new Object[0]);
        GeneratorUtils.notNull(publicKeyHeight, "publicKeyHeight is null", new Object[0]);
        GeneratorUtils.notNull(accountType, "accountType is null", new Object[0]);
        GeneratorUtils.notNull(format, "format is null", new Object[0]);
        GeneratorUtils.notNull(supplementalAccountKeysMask, "supplementalAccountKeysMask is null", new Object[0]);
        if (supplementalAccountKeysMask.contains(AccountKeyFlagsDto.LINKED)) {
            GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        }
        if (supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VRF)) {
            GeneratorUtils.notNull(vrfPublicKey, "vrfPublicKey is null", new Object[0]);
        }
        if (supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VOTING)) {
            GeneratorUtils.notNull(votingPublicKey, "votingPublicKey is null", new Object[0]);
        }
        if (supplementalAccountKeysMask.contains(AccountKeyFlagsDto.NODE)) {
            GeneratorUtils.notNull(nodePublicKey, "nodePublicKey is null", new Object[0]);
        }
        if (format == AccountStateFormatDto.HIGH_VALUE) {
            GeneratorUtils.notNull(importanceSnapshots, "importanceSnapshots is null", new Object[0]);
        }
        if (format == AccountStateFormatDto.HIGH_VALUE) {
            GeneratorUtils.notNull(activityBuckets, "activityBuckets is null", new Object[0]);
        }
        GeneratorUtils.notNull(currencyMosaicId, "currencyMosaicId is null", new Object[0]);
        GeneratorUtils.notNull(balances, "balances is null", new Object[0]);
        this.address = address;
        this.addressHeight = addressHeight;
        this.publicKey = publicKey;
        this.publicKeyHeight = publicKeyHeight;
        this.accountType = accountType;
        this.format = format;
        this.supplementalAccountKeysMask = supplementalAccountKeysMask;
        this.linkedPublicKey = linkedPublicKey;
        this.vrfPublicKey = vrfPublicKey;
        this.votingPublicKey = votingPublicKey;
        this.nodePublicKey = nodePublicKey;
        this.importanceSnapshots = importanceSnapshots;
        this.activityBuckets = activityBuckets;
        this.currencyMosaicId = currencyMosaicId;
        this.balances = balances;
    }

    public static AccountStateBuilder createHighValue(AddressDto address, HeightDto addressHeight, KeyDto publicKey, HeightDto publicKeyHeight, AccountTypeDto accountType, EnumSet<AccountKeyFlagsDto> supplementalAccountKeysMask, KeyDto linkedPublicKey, KeyDto vrfPublicKey, VotingKeyDto votingPublicKey, KeyDto nodePublicKey, ImportanceSnapshotBuilder importanceSnapshots, HeightActivityBucketsBuilder activityBuckets, MosaicIdDto currencyMosaicId, List<MosaicBuilder> balances) {
        AccountStateFormatDto format = AccountStateFormatDto.HIGH_VALUE;
        return new AccountStateBuilder(address, addressHeight, publicKey, publicKeyHeight, accountType, format, supplementalAccountKeysMask, linkedPublicKey, vrfPublicKey, votingPublicKey, nodePublicKey, importanceSnapshots, activityBuckets, currencyMosaicId, balances);
    }

    public static AccountStateBuilder createRegular(AddressDto address, HeightDto addressHeight, KeyDto publicKey, HeightDto publicKeyHeight, AccountTypeDto accountType, EnumSet<AccountKeyFlagsDto> supplementalAccountKeysMask, KeyDto linkedPublicKey, KeyDto vrfPublicKey, VotingKeyDto votingPublicKey, KeyDto nodePublicKey, MosaicIdDto currencyMosaicId, List<MosaicBuilder> balances) {
        AccountStateFormatDto format = AccountStateFormatDto.REGULAR;
        return new AccountStateBuilder(address, addressHeight, publicKey, publicKeyHeight, accountType, format, supplementalAccountKeysMask, linkedPublicKey, vrfPublicKey, votingPublicKey, nodePublicKey, null, null, currencyMosaicId, balances);
    }

    public AddressDto getAddress() {
        return this.address;
    }

    public HeightDto getAddressHeight() {
        return this.addressHeight;
    }

    public KeyDto getPublicKey() {
        return this.publicKey;
    }

    public HeightDto getPublicKeyHeight() {
        return this.publicKeyHeight;
    }

    public AccountTypeDto getAccountType() {
        return this.accountType;
    }

    public AccountStateFormatDto getFormat() {
        return this.format;
    }

    public EnumSet<AccountKeyFlagsDto> getSupplementalAccountKeysMask() {
        return this.supplementalAccountKeysMask;
    }

    public KeyDto getLinkedPublicKey() {
        if (!this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.LINKED)) {
            throw new IllegalStateException("supplementalAccountKeysMask is not set to LINKED.");
        }
        return this.linkedPublicKey;
    }

    public KeyDto getVrfPublicKey() {
        if (!this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VRF)) {
            throw new IllegalStateException("supplementalAccountKeysMask is not set to VRF.");
        }
        return this.vrfPublicKey;
    }

    public VotingKeyDto getVotingPublicKey() {
        if (!this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VOTING)) {
            throw new IllegalStateException("supplementalAccountKeysMask is not set to VOTING.");
        }
        return this.votingPublicKey;
    }

    public KeyDto getNodePublicKey() {
        if (!this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.NODE)) {
            throw new IllegalStateException("supplementalAccountKeysMask is not set to NODE.");
        }
        return this.nodePublicKey;
    }

    public ImportanceSnapshotBuilder getImportanceSnapshots() {
        if (this.format != AccountStateFormatDto.HIGH_VALUE) {
            throw new IllegalStateException("format is not set to HIGH_VALUE.");
        }
        return this.importanceSnapshots;
    }

    public HeightActivityBucketsBuilder getActivityBuckets() {
        if (this.format != AccountStateFormatDto.HIGH_VALUE) {
            throw new IllegalStateException("format is not set to HIGH_VALUE.");
        }
        return this.activityBuckets;
    }

    public MosaicIdDto getCurrencyMosaicId() {
        return this.currencyMosaicId;
    }

    public List<MosaicBuilder> getBalances() {
        return this.balances;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.address.getSize();
        size += this.addressHeight.getSize();
        size += this.publicKey.getSize();
        size += this.publicKeyHeight.getSize();
        size += this.accountType.getSize();
        size += this.format.getSize();
        size += AccountKeyFlagsDto.values()[0].getSize();
        if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.LINKED)) {
            size += this.linkedPublicKey.getSize();
        }
        if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VRF)) {
            size += this.vrfPublicKey.getSize();
        }
        if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VOTING)) {
            size += this.votingPublicKey.getSize();
        }
        if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.NODE)) {
            size += this.nodePublicKey.getSize();
        }
        if (this.format == AccountStateFormatDto.HIGH_VALUE) {
            size += this.importanceSnapshots.getSize();
        }
        if (this.format == AccountStateFormatDto.HIGH_VALUE) {
            size += this.activityBuckets.getSize();
        }
        size += this.currencyMosaicId.getSize();
        size += 2;
        return size += this.balances.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.address);
            GeneratorUtils.writeEntity(dataOutputStream, this.addressHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.publicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.publicKeyHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.accountType);
            GeneratorUtils.writeEntity(dataOutputStream, this.format);
            dataOutputStream.writeByte((byte)GeneratorUtils.toLong(AccountKeyFlagsDto.class, this.supplementalAccountKeysMask));
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.LINKED)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.linkedPublicKey);
            }
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VRF)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.vrfPublicKey);
            }
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.VOTING)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.votingPublicKey);
            }
            if (this.supplementalAccountKeysMask.contains(AccountKeyFlagsDto.NODE)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.nodePublicKey);
            }
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                GeneratorUtils.writeEntity(dataOutputStream, this.importanceSnapshots);
            }
            if (this.format == AccountStateFormatDto.HIGH_VALUE) {
                GeneratorUtils.writeEntity(dataOutputStream, this.activityBuckets);
            }
            GeneratorUtils.writeEntity(dataOutputStream, this.currencyMosaicId);
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.getSize(this.getBalances())));
            GeneratorUtils.writeList(dataOutputStream, this.balances);
        });
    }
}

