/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountRestrictionsInfoBuilder;
import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class AccountRestrictionsBuilder
implements Serializer {
    private final AddressDto address;
    private final List<AccountRestrictionsInfoBuilder> restrictions;

    protected AccountRestrictionsBuilder(DataInputStream stream) {
        try {
            this.address = AddressDto.loadFromBinary(stream);
            long restrictionsCount = Long.reverseBytes(stream.readLong());
            this.restrictions = GeneratorUtils.loadFromBinaryArray(AccountRestrictionsInfoBuilder::loadFromBinary, stream, restrictionsCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountRestrictionsBuilder loadFromBinary(DataInputStream stream) {
        return new AccountRestrictionsBuilder(stream);
    }

    protected AccountRestrictionsBuilder(AddressDto address, List<AccountRestrictionsInfoBuilder> restrictions) {
        GeneratorUtils.notNull(address, "address is null", new Object[0]);
        GeneratorUtils.notNull(restrictions, "restrictions is null", new Object[0]);
        this.address = address;
        this.restrictions = restrictions;
    }

    public static AccountRestrictionsBuilder create(AddressDto address, List<AccountRestrictionsInfoBuilder> restrictions) {
        return new AccountRestrictionsBuilder(address, restrictions);
    }

    public AddressDto getAddress() {
        return this.address;
    }

    public List<AccountRestrictionsInfoBuilder> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.address.getSize();
        size += 8;
        return size += this.restrictions.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.address);
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getRestrictions())));
            GeneratorUtils.writeList(dataOutputStream, this.restrictions);
        });
    }
}

