/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BitMaskable;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum AccountRestrictionFlagsDto implements BitMaskable,
Serializer
{
    ADDRESS(1),
    MOSAIC_ID(2),
    TRANSACTION_TYPE(4),
    OUTGOING(16384),
    BLOCK(Short.MIN_VALUE);

    private final short value;

    private AccountRestrictionFlagsDto(short value) {
        this.value = value;
    }

    public static AccountRestrictionFlagsDto rawValueOf(short value) {
        for (AccountRestrictionFlagsDto current : AccountRestrictionFlagsDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for AccountRestrictionFlagsDto.");
    }

    @Override
    public int getSize() {
        return 2;
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public long getValueAsLong() {
        return this.value;
    }

    public static AccountRestrictionFlagsDto loadFromBinary(DataInputStream stream) {
        try {
            short streamValue = Short.reverseBytes(stream.readShort());
            return AccountRestrictionFlagsDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeShort(Short.reverseBytes(this.value)));
    }
}

