/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class AccountMetadataTransactionBodyBuilder
implements Serializer {
    private final KeyDto targetPublicKey;
    private final long scopedMetadataKey;
    private final short valueSizeDelta;
    private final ByteBuffer value;

    protected AccountMetadataTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.targetPublicKey = KeyDto.loadFromBinary(stream);
            this.scopedMetadataKey = Long.reverseBytes(stream.readLong());
            this.valueSizeDelta = Short.reverseBytes(stream.readShort());
            short valueSize = Short.reverseBytes(stream.readShort());
            this.value = GeneratorUtils.readByteBuffer(stream, valueSize);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountMetadataTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountMetadataTransactionBodyBuilder(stream);
    }

    protected AccountMetadataTransactionBodyBuilder(KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        GeneratorUtils.notNull(targetPublicKey, "targetPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(scopedMetadataKey, "scopedMetadataKey is null", new Object[0]);
        GeneratorUtils.notNull(valueSizeDelta, "valueSizeDelta is null", new Object[0]);
        GeneratorUtils.notNull(value, "value is null", new Object[0]);
        this.targetPublicKey = targetPublicKey;
        this.scopedMetadataKey = scopedMetadataKey;
        this.valueSizeDelta = valueSizeDelta;
        this.value = value;
    }

    public static AccountMetadataTransactionBodyBuilder create(KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        return new AccountMetadataTransactionBodyBuilder(targetPublicKey, scopedMetadataKey, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.targetPublicKey;
    }

    public long getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public short getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.targetPublicKey.getSize();
        size += 8;
        size += 2;
        size += 2;
        return size += this.value.array().length;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.targetPublicKey);
            dataOutputStream.writeLong(Long.reverseBytes(this.getScopedMetadataKey()));
            dataOutputStream.writeShort(Short.reverseBytes(this.getValueSizeDelta()));
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.getSize(this.getValue())));
            dataOutputStream.write(this.value.array(), 0, this.value.array().length);
        });
    }
}

