/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class AccountKeyLinkTransactionBodyBuilder
implements Serializer {
    private final KeyDto remotePublicKey;
    private final LinkActionDto linkAction;

    protected AccountKeyLinkTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.remotePublicKey = KeyDto.loadFromBinary(stream);
            this.linkAction = LinkActionDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountKeyLinkTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountKeyLinkTransactionBodyBuilder(stream);
    }

    protected AccountKeyLinkTransactionBodyBuilder(KeyDto remotePublicKey, LinkActionDto linkAction) {
        GeneratorUtils.notNull(remotePublicKey, "remotePublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.remotePublicKey = remotePublicKey;
        this.linkAction = linkAction;
    }

    public static AccountKeyLinkTransactionBodyBuilder create(KeyDto remotePublicKey, LinkActionDto linkAction) {
        return new AccountKeyLinkTransactionBodyBuilder(remotePublicKey, linkAction);
    }

    public KeyDto getRemotePublicKey() {
        return this.remotePublicKey;
    }

    public LinkActionDto getLinkAction() {
        return this.linkAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.remotePublicKey.getSize();
        return size += this.linkAction.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.remotePublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.linkAction);
        });
    }
}

