/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BitMaskable;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum AccountKeyFlagsDto implements BitMaskable,
Serializer
{
    UNSET(0),
    LINKED(1),
    VRF(2),
    VOTING(4),
    NODE(8);

    private final byte value;

    private AccountKeyFlagsDto(byte value) {
        this.value = value;
    }

    public static AccountKeyFlagsDto rawValueOf(byte value) {
        for (AccountKeyFlagsDto current : AccountKeyFlagsDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for AccountKeyFlagsDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public long getValueAsLong() {
        return this.value;
    }

    public static AccountKeyFlagsDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return AccountKeyFlagsDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

