package io.nem.sdk.openapi.vertx.api.rxjava;

import io.nem.sdk.openapi.vertx.model.AnnounceTransactionInfoDTO;
import io.nem.sdk.openapi.vertx.model.Cosignature;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.TransactionHashes;
import io.nem.sdk.openapi.vertx.model.TransactionIds;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.sdk.openapi.vertx.model.TransactionStatusDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-18T19:12:35.788Z[UTC]")
public class TransactionRoutesApi {

	private final io.nem.sdk.openapi.vertx.api.TransactionRoutesApi delegate;

	public TransactionRoutesApi(io.nem.sdk.openapi.vertx.api.TransactionRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.sdk.openapi.vertx.api.TransactionRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceCosignatureTransaction(Cosignature cosignature, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        delegate.announceCosignatureTransaction(cosignature, resultHandler);
    }

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AnnounceTransactionInfoDTO> rxAnnounceCosignatureTransaction(Cosignature cosignature) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.announceCosignatureTransaction(cosignature, fut);
        }));
    }
    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announcePartialTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        delegate.announcePartialTransaction(transactionPayload, resultHandler);
    }

    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AnnounceTransactionInfoDTO> rxAnnouncePartialTransaction(TransactionPayload transactionPayload) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.announcePartialTransaction(transactionPayload, fut);
        }));
    }
    /**
     * Announce a new transaction
     * Announces a transaction to the network. We recommended to use the NEM2-SDK to announce transactions as they should be serialized. 
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        delegate.announceTransaction(transactionPayload, resultHandler);
    }

    /**
     * Announce a new transaction
     * Announces a transaction to the network. We recommended to use the NEM2-SDK to announce transactions as they should be serialized. 
     * @param transactionPayload  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AnnounceTransactionInfoDTO> rxAnnounceTransaction(TransactionPayload transactionPayload) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.announceTransaction(transactionPayload, fut);
        }));
    }
    /**
     * Get transaction information
     * Returns transaction information given a transactionId or hash.
     * @param transactionId Transaction identifier or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        delegate.getTransaction(transactionId, resultHandler);
    }

    /**
     * Get transaction information
     * Returns transaction information given a transactionId or hash.
     * @param transactionId Transaction identifier or hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionInfoDTO> rxGetTransaction(String transactionId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getTransaction(transactionId, fut);
        }));
    }
    /**
     * Get transaction status
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactionStatus(String hash, Handler<AsyncResult<TransactionStatusDTO>> resultHandler) {
        delegate.getTransactionStatus(hash, resultHandler);
    }

    /**
     * Get transaction status
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionStatusDTO> rxGetTransactionStatus(String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getTransactionStatus(hash, fut);
        }));
    }
    /**
     * Get transactions information
     * Returns transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getTransactions(transactionIds, resultHandler);
    }

    /**
     * Get transactions information
     * Returns transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetTransactions(TransactionIds transactionIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getTransactions(transactionIds, fut);
        }));
    }
    /**
     * Get transactions status
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactionsStatuses(TransactionHashes transactionHashes, Handler<AsyncResult<List<TransactionStatusDTO>>> resultHandler) {
        delegate.getTransactionsStatuses(transactionHashes, resultHandler);
    }

    /**
     * Get transactions status
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionStatusDTO>> rxGetTransactionsStatuses(TransactionHashes transactionHashes) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getTransactionsStatuses(transactionHashes, fut);
        }));
    }

    public static TransactionRoutesApi newInstance(io.nem.sdk.openapi.vertx.api.TransactionRoutesApi arg) {
        return arg != null ? new TransactionRoutesApi(arg) : null;
    }
}
