package io.nem.sdk.openapi.vertx.api.rxjava;

import io.nem.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-18T19:12:35.788Z[UTC]")
public class BlockRoutesApi {

	private final io.nem.sdk.openapi.vertx.api.BlockRoutesApi delegate;

	public BlockRoutesApi(io.nem.sdk.openapi.vertx.api.BlockRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.sdk.openapi.vertx.api.BlockRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockByHeight(java.math.BigInteger height, Handler<AsyncResult<BlockInfoDTO>> resultHandler) {
        delegate.getBlockByHeight(height, resultHandler);
    }

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height.  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<BlockInfoDTO> rxGetBlockByHeight(java.math.BigInteger height) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlockByHeight(height, fut);
        }));
    }
    /**
     * Get transactions from a block
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height.  (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockTransactions(java.math.BigInteger height, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getBlockTransactions(height, pageSize, id, ordering, resultHandler);
    }

    /**
     * Get transactions from a block
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height.  (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetBlockTransactions(java.math.BigInteger height, Integer pageSize, String id, String ordering) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlockTransactions(height, pageSize, id, ordering, fut);
        }));
    }
    /**
     * Get blocks information
     * Gets up to limit number of blocks after given block height.
     * @param height Block height.  (required)
     * @param limit Number of elements to be returned. The limit should be greater than or equal to \&quot;db.pageSizeMin\&quot; and not higher than \&quot;db.pageSizeMax\&quot;. The settings are adjustable via a configuration file (rest/resources/rest.json) per REST instance.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlocksByHeightWithLimit(java.math.BigInteger height, Integer limit, Handler<AsyncResult<List<BlockInfoDTO>>> resultHandler) {
        delegate.getBlocksByHeightWithLimit(height, limit, resultHandler);
    }

    /**
     * Get blocks information
     * Gets up to limit number of blocks after given block height.
     * @param height Block height.  (required)
     * @param limit Number of elements to be returned. The limit should be greater than or equal to \&quot;db.pageSizeMin\&quot; and not higher than \&quot;db.pageSizeMax\&quot;. The settings are adjustable via a configuration file (rest/resources/rest.json) per REST instance.  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<BlockInfoDTO>> rxGetBlocksByHeightWithLimit(java.math.BigInteger height, Integer limit) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlocksByHeightWithLimit(height, limit, fut);
        }));
    }
    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
     * @param height Block height.  (required)
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleTransaction(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        delegate.getMerkleTransaction(height, hash, resultHandler);
    }

    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
     * @param height Block height.  (required)
     * @param hash Transaction hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleProofInfoDTO> rxGetMerkleTransaction(java.math.BigInteger height, String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMerkleTransaction(height, hash, fut);
        }));
    }

    public static BlockRoutesApi newInstance(io.nem.sdk.openapi.vertx.api.BlockRoutesApi arg) {
        return arg != null ? new BlockRoutesApi(arg) : null;
    }
}
