package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.nem.sdk.openapi.vertx.invoker.Configuration;
import io.nem.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-18T19:12:35.788Z[UTC]")
public class RestrictionAccountRoutesApiImpl implements RestrictionAccountRoutesApi {

    private ApiClient apiClient;

    public RestrictionAccountRoutesApiImpl() {
        this(null);
    }

    public RestrictionAccountRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictions(String accountId, Handler<AsyncResult<AccountRestrictionsInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountRestrictions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/restrictions/account/{accountId}".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AccountRestrictionsInfoDTO> localVarReturnType = new TypeReference<AccountRestrictionsInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get account restrictions for given array of addresses
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictionsFromAccounts(AccountIds accountIds, Handler<AsyncResult<List<AccountRestrictionsInfoDTO>>> resultHandler) {
        Object localVarBody = accountIds;
        
        // create path and map variables
        String localVarPath = "/restrictions/account";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<AccountRestrictionsInfoDTO>> localVarReturnType = new TypeReference<List<AccountRestrictionsInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
