package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.MosaicIds;
import io.nem.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.sdk.openapi.vertx.model.NamespacesInfoDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface NamespaceRoutesApi {

    void getAccountsNames(AccountIds accountIds, Handler<AsyncResult<AccountsNamesDTO>> handler);

    void getMosaicsNames(MosaicIds mosaicIds, Handler<AsyncResult<MosaicsNamesDTO>> handler);

    void getNamespace(String namespaceId, Handler<AsyncResult<NamespaceInfoDTO>> handler);

    void getNamespacesFromAccount(String accountId, Integer pageSize, String id, Handler<AsyncResult<NamespacesInfoDTO>> handler);

    void getNamespacesFromAccounts(AccountIds accountIds, Handler<AsyncResult<NamespacesInfoDTO>> handler);

    void getNamespacesNames(NamespaceIds namespaceIds, Handler<AsyncResult<List<NamespaceNameDTO>>> handler);

}
