package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface MetadataRoutesApi {

    void getAccountMetadata(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getAccountMetadataByKey(String accountId, String key, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getAccountMetadataByKeyAndSender(String accountId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> handler);

    void getMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getMosaicMetadataByKey(String mosaicId, String key, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> handler);

    void getNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getNamespaceMetadataByKey(String namespaceId, String key, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> handler);

}
