package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.nem.sdk.openapi.vertx.invoker.Configuration;
import io.nem.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-18T19:12:35.788Z[UTC]")
public class BlockRoutesApiImpl implements BlockRoutesApi {

    private ApiClient apiClient;

    public BlockRoutesApiImpl() {
        this(null);
    }

    public BlockRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockByHeight(java.math.BigInteger height, Handler<AsyncResult<BlockInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlockByHeight"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/block/{height}".replaceAll("\\{" + "height" + "\\}", height.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<BlockInfoDTO> localVarReturnType = new TypeReference<BlockInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get transactions from a block
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height.  (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockTransactions(java.math.BigInteger height, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlockTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/block/{height}/transactions".replaceAll("\\{" + "height" + "\\}", height.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get blocks information
     * Gets up to limit number of blocks after given block height.
     * @param height Block height.  (required)
     * @param limit Number of elements to be returned. The limit should be greater than or equal to \&quot;db.pageSizeMin\&quot; and not higher than \&quot;db.pageSizeMax\&quot;. The settings are adjustable via a configuration file (rest/resources/rest.json) per REST instance.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlocksByHeightWithLimit(java.math.BigInteger height, Integer limit, Handler<AsyncResult<List<BlockInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlocksByHeightWithLimit"));
            return;
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'limit' when calling getBlocksByHeightWithLimit"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/blocks/{height}/limit/{limit}".replaceAll("\\{" + "height" + "\\}", height.toString()).replaceAll("\\{" + "limit" + "\\}", limit.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<BlockInfoDTO>> localVarReturnType = new TypeReference<List<BlockInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
     * @param height Block height.  (required)
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleTransaction(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getMerkleTransaction"));
            return;
        }
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getMerkleTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/block/{height}/transaction/{hash}/merkle".replaceAll("\\{" + "height" + "\\}", height.toString()).replaceAll("\\{" + "hash" + "\\}", hash.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MerkleProofInfoDTO> localVarReturnType = new TypeReference<MerkleProofInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
