/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

public class EmbeddedMosaicMetadataTransactionDTO {
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    @JsonProperty(value="network")
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_TARGET_PUBLIC_KEY = "targetPublicKey";
    @JsonProperty(value="targetPublicKey")
    private String targetPublicKey;
    public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
    @JsonProperty(value="scopedMetadataKey")
    private String scopedMetadataKey;
    public static final String JSON_PROPERTY_TARGET_MOSAIC_ID = "targetMosaicId";
    @JsonProperty(value="targetMosaicId")
    private String targetMosaicId;
    public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
    @JsonProperty(value="valueSizeDelta")
    private Integer valueSizeDelta;
    public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
    @JsonProperty(value="valueSize")
    private Integer valueSize;
    public static final String JSON_PROPERTY_VALUE = "value";
    @JsonProperty(value="value")
    private String value;

    public EmbeddedMosaicMetadataTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public EmbeddedMosaicMetadataTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public EmbeddedMosaicMetadataTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public EmbeddedMosaicMetadataTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public EmbeddedMosaicMetadataTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public EmbeddedMosaicMetadataTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public EmbeddedMosaicMetadataTransactionDTO targetPublicKey(String targetPublicKey) {
        this.targetPublicKey = targetPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    public String getTargetPublicKey() {
        return this.targetPublicKey;
    }

    public void setTargetPublicKey(String targetPublicKey) {
        this.targetPublicKey = targetPublicKey;
    }

    public EmbeddedMosaicMetadataTransactionDTO scopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Metadata key scoped to source, target and type expressed.")
    public String getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public void setScopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    public EmbeddedMosaicMetadataTransactionDTO targetMosaicId(String targetMosaicId) {
        this.targetMosaicId = targetMosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    public String getTargetMosaicId() {
        return this.targetMosaicId;
    }

    public void setTargetMosaicId(String targetMosaicId) {
        this.targetMosaicId = targetMosaicId;
    }

    public EmbeddedMosaicMetadataTransactionDTO valueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
        return this;
    }

    @ApiModelProperty(required=true, value="Change in value size in bytes.")
    public Integer getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public void setValueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
    }

    public EmbeddedMosaicMetadataTransactionDTO valueSize(Integer valueSize) {
        this.valueSize = valueSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Value size in bytes.")
    public Integer getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(Integer valueSize) {
        this.valueSize = valueSize;
    }

    public EmbeddedMosaicMetadataTransactionDTO value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedMosaicMetadataTransactionDTO embeddedMosaicMetadataTransactionDTO = (EmbeddedMosaicMetadataTransactionDTO)o;
        return Objects.equals(this.signerPublicKey, embeddedMosaicMetadataTransactionDTO.signerPublicKey) && Objects.equals(this.version, embeddedMosaicMetadataTransactionDTO.version) && Objects.equals((Object)this.network, (Object)embeddedMosaicMetadataTransactionDTO.network) && Objects.equals(this.type, embeddedMosaicMetadataTransactionDTO.type) && Objects.equals(this.maxFee, embeddedMosaicMetadataTransactionDTO.maxFee) && Objects.equals(this.deadline, embeddedMosaicMetadataTransactionDTO.deadline) && Objects.equals(this.targetPublicKey, embeddedMosaicMetadataTransactionDTO.targetPublicKey) && Objects.equals(this.scopedMetadataKey, embeddedMosaicMetadataTransactionDTO.scopedMetadataKey) && Objects.equals(this.targetMosaicId, embeddedMosaicMetadataTransactionDTO.targetMosaicId) && Objects.equals(this.valueSizeDelta, embeddedMosaicMetadataTransactionDTO.valueSizeDelta) && Objects.equals(this.valueSize, embeddedMosaicMetadataTransactionDTO.valueSize) && Objects.equals(this.value, embeddedMosaicMetadataTransactionDTO.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.targetPublicKey, this.scopedMetadataKey, this.targetMosaicId, this.valueSizeDelta, this.valueSize, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmbeddedMosaicMetadataTransactionDTO {\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    targetPublicKey: ").append(this.toIndentedString(this.targetPublicKey)).append("\n");
        sb.append("    scopedMetadataKey: ").append(this.toIndentedString(this.scopedMetadataKey)).append("\n");
        sb.append("    targetMosaicId: ").append(this.toIndentedString(this.targetMosaicId)).append("\n");
        sb.append("    valueSizeDelta: ").append(this.toIndentedString(this.valueSizeDelta)).append("\n");
        sb.append("    valueSize: ").append(this.toIndentedString(this.valueSize)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

