/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.sdk.openapi.vertx.api.TransactionRoutesApi;
import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.nem.sdk.openapi.vertx.invoker.Configuration;
import io.nem.sdk.openapi.vertx.invoker.Pair;
import io.nem.sdk.openapi.vertx.model.AnnounceTransactionInfoDTO;
import io.nem.sdk.openapi.vertx.model.Cosignature;
import io.nem.sdk.openapi.vertx.model.TransactionHashes;
import io.nem.sdk.openapi.vertx.model.TransactionIds;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.sdk.openapi.vertx.model.TransactionStatusDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TransactionRoutesApiImpl
implements TransactionRoutesApi {
    private ApiClient apiClient;

    public TransactionRoutesApiImpl() {
        this(null);
    }

    public TransactionRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void announceCosignatureTransaction(Cosignature cosignature, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        Cosignature localVarBody = cosignature;
        if (cosignature == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'cosignature' when calling announceCosignatureTransaction"));
            return;
        }
        String localVarPath = "/transaction/cosignature";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void announcePartialTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        TransactionPayload localVarBody = transactionPayload;
        if (transactionPayload == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionPayload' when calling announcePartialTransaction"));
            return;
        }
        String localVarPath = "/transaction/partial";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void announceTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        TransactionPayload localVarBody = transactionPayload;
        if (transactionPayload == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionPayload' when calling announceTransaction"));
            return;
        }
        String localVarPath = "/transaction";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (transactionId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionId' when calling getTransaction"));
            return;
        }
        String localVarPath = "/transaction/{transactionId}".replaceAll("\\{transactionId\\}", transactionId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<TransactionInfoDTO> localVarReturnType = new TypeReference<TransactionInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getTransactionStatus(String hash, Handler<AsyncResult<TransactionStatusDTO>> resultHandler) {
        Object localVarBody = null;
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getTransactionStatus"));
            return;
        }
        String localVarPath = "/transaction/{hash}/status".replaceAll("\\{hash\\}", hash.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<TransactionStatusDTO> localVarReturnType = new TypeReference<TransactionStatusDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        TransactionIds localVarBody = transactionIds;
        if (transactionIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionIds' when calling getTransactions"));
            return;
        }
        String localVarPath = "/transaction";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>(){};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getTransactionsStatuses(TransactionHashes transactionHashes, Handler<AsyncResult<List<TransactionStatusDTO>>> resultHandler) {
        TransactionHashes localVarBody = transactionHashes;
        if (transactionHashes == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionHashes' when calling getTransactionsStatuses"));
            return;
        }
        String localVarPath = "/transaction/statuses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<TransactionStatusDTO>> localVarReturnType = new TypeReference<List<TransactionStatusDTO>>(){};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

