/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to create a new mosaic.")
public class MosaicDefinitionTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    @JsonProperty(value="network")
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private String id;
    public static final String JSON_PROPERTY_DURATION = "duration";
    @JsonProperty(value="duration")
    private BigInteger duration = null;
    public static final String JSON_PROPERTY_NONCE = "nonce";
    @JsonProperty(value="nonce")
    private Long nonce;
    public static final String JSON_PROPERTY_FLAGS = "flags";
    @JsonProperty(value="flags")
    private Integer flags;
    public static final String JSON_PROPERTY_DIVISIBILITY = "divisibility";
    @JsonProperty(value="divisibility")
    private Integer divisibility;

    public MosaicDefinitionTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public MosaicDefinitionTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public MosaicDefinitionTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MosaicDefinitionTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public MosaicDefinitionTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public MosaicDefinitionTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public MosaicDefinitionTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public MosaicDefinitionTransactionDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MosaicDefinitionTransactionDTO duration(BigInteger duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDuration() {
        return this.duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public MosaicDefinitionTransactionDTO nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Random nonce used to generate the mosaic id.")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public MosaicDefinitionTransactionDTO flags(Integer flags) {
        this.flags = flags;
        return this;
    }

    @ApiModelProperty(required=true, value="- 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner. ")
    public Integer getFlags() {
        return this.flags;
    }

    public void setFlags(Integer flags) {
        this.flags = flags;
    }

    public MosaicDefinitionTransactionDTO divisibility(Integer divisibility) {
        this.divisibility = divisibility;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6. ")
    public Integer getDivisibility() {
        return this.divisibility;
    }

    public void setDivisibility(Integer divisibility) {
        this.divisibility = divisibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicDefinitionTransactionDTO mosaicDefinitionTransactionDTO = (MosaicDefinitionTransactionDTO)o;
        return Objects.equals(this.signature, mosaicDefinitionTransactionDTO.signature) && Objects.equals(this.signerPublicKey, mosaicDefinitionTransactionDTO.signerPublicKey) && Objects.equals(this.version, mosaicDefinitionTransactionDTO.version) && Objects.equals((Object)this.network, (Object)mosaicDefinitionTransactionDTO.network) && Objects.equals(this.type, mosaicDefinitionTransactionDTO.type) && Objects.equals(this.maxFee, mosaicDefinitionTransactionDTO.maxFee) && Objects.equals(this.deadline, mosaicDefinitionTransactionDTO.deadline) && Objects.equals(this.id, mosaicDefinitionTransactionDTO.id) && Objects.equals(this.duration, mosaicDefinitionTransactionDTO.duration) && Objects.equals(this.nonce, mosaicDefinitionTransactionDTO.nonce) && Objects.equals(this.flags, mosaicDefinitionTransactionDTO.flags) && Objects.equals(this.divisibility, mosaicDefinitionTransactionDTO.divisibility);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.id, this.duration, this.nonce, this.flags, this.divisibility});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicDefinitionTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    divisibility: ").append(this.toIndentedString(this.divisibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

