package io.nem.sdk.openapi.vertx.api.rxjava;

import io.nem.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.StatementsDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-11-23T10:26:45.594287+01:00[Europe/Madrid]")
public class ReceiptRoutesApi {

	private final io.nem.sdk.openapi.vertx.api.ReceiptRoutesApi delegate;

	public ReceiptRoutesApi(io.nem.sdk.openapi.vertx.api.ReceiptRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.sdk.openapi.vertx.api.ReceiptRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get receipts from a block
     * Returns the receipts linked to a block.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockReceipts(java.math.BigInteger height, Handler<AsyncResult<StatementsDTO>> resultHandler) {
        delegate.getBlockReceipts(height, resultHandler);
    }

    /**
     * Get receipts from a block
     * Returns the receipts linked to a block.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<StatementsDTO> rxGetBlockReceipts(java.math.BigInteger height) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlockReceipts(height, fut);
        }));
    }
    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param hash Receipt hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleReceipts(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        delegate.getMerkleReceipts(height, hash, resultHandler);
    }

    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param hash Receipt hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleProofInfoDTO> rxGetMerkleReceipts(java.math.BigInteger height, String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMerkleReceipts(height, hash, fut);
        }));
    }

    public static ReceiptRoutesApi newInstance(io.nem.sdk.openapi.vertx.api.ReceiptRoutesApi arg) {
        return arg != null ? new ReceiptRoutesApi(arg) : null;
    }
}
