package io.nem.sdk.openapi.vertx.api.rxjava;

import io.nem.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-11-23T10:26:45.594287+01:00[Europe/Madrid]")
public class BlockRoutesApi {

	private final io.nem.sdk.openapi.vertx.api.BlockRoutesApi delegate;

	public BlockRoutesApi(io.nem.sdk.openapi.vertx.api.BlockRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.sdk.openapi.vertx.api.BlockRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockByHeight(java.math.BigInteger height, Handler<AsyncResult<BlockInfoDTO>> resultHandler) {
        delegate.getBlockByHeight(height, resultHandler);
    }

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<BlockInfoDTO> rxGetBlockByHeight(java.math.BigInteger height) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlockByHeight(height, fut);
        }));
    }
    /**
     * Get transactions from a block
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockTransactions(java.math.BigInteger height, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getBlockTransactions(height, pageSize, id, ordering, resultHandler);
    }

    /**
     * Get transactions from a block
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetBlockTransactions(java.math.BigInteger height, Integer pageSize, String id, String ordering) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlockTransactions(height, pageSize, id, ordering, fut);
        }));
    }
    /**
     * Get blocks information
     * Gets up to limit number of blocks after given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param limit Number of elements to be returned. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlocksByHeightWithLimit(java.math.BigInteger height, Integer limit, Handler<AsyncResult<List<BlockInfoDTO>>> resultHandler) {
        delegate.getBlocksByHeightWithLimit(height, limit, resultHandler);
    }

    /**
     * Get blocks information
     * Gets up to limit number of blocks after given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param limit Number of elements to be returned. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<BlockInfoDTO>> rxGetBlocksByHeightWithLimit(java.math.BigInteger height, Integer limit) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlocksByHeightWithLimit(height, limit, fut);
        }));
    }
    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the transaction was included in the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleTransaction(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        delegate.getMerkleTransaction(height, hash, resultHandler);
    }

    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the transaction was included in the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead.  (required)
     * @param hash Transaction hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleProofInfoDTO> rxGetMerkleTransaction(java.math.BigInteger height, String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMerkleTransaction(height, hash, fut);
        }));
    }

    public static BlockRoutesApi newInstance(io.nem.sdk.openapi.vertx.api.BlockRoutesApi arg) {
        return arg != null ? new BlockRoutesApi(arg) : null;
    }
}
