package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.NodeInfoDTO;
import io.nem.sdk.openapi.vertx.model.NodeTimeDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.nem.sdk.openapi.vertx.invoker.Configuration;
import io.nem.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-11-23T10:26:45.594287+01:00[Europe/Madrid]")
public class NodeRoutesApiImpl implements NodeRoutesApi {

    private ApiClient apiClient;

    public NodeRoutesApiImpl() {
        this(null);
    }

    public NodeRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get the node information
     * Supplies additional information about the application running on a node.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeInfo(Handler<AsyncResult<NodeInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/info";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NodeInfoDTO> localVarReturnType = new TypeReference<NodeInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the node time
     * Gets the node time at the moment the reply was sent and received.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeTime(Handler<AsyncResult<NodeTimeDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/time";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NodeTimeDTO> localVarReturnType = new TypeReference<NodeTimeDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
