package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface AccountRoutesApi {

    void getAccountIncomingTransactions(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getAccountInfo(String accountId, Handler<AsyncResult<AccountInfoDTO>> handler);

    void getAccountOutgoingTransactions(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getAccountPartialTransactions(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getAccountTransactions(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getAccountUnconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getAccountsInfo(AccountIds accountIds, Handler<AsyncResult<List<AccountInfoDTO>>> handler);

}
