package io.nem.sdk.openapi.vertx.api.rxjava;

import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-01T18:24:23.294947664-03:00[America/Argentina/Buenos_Aires]")
public class RestrictionAccountRoutesApi {

	private final io.nem.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate;

	public RestrictionAccountRoutesApi(io.nem.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.sdk.openapi.vertx.api.RestrictionAccountRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictions(String accountId, Handler<AsyncResult<AccountRestrictionsInfoDTO>> resultHandler) {
        delegate.getAccountRestrictions(accountId, resultHandler);
    }

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountRestrictionsInfoDTO> rxGetAccountRestrictions(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountRestrictions(accountId, fut);
        }));
    }
    /**
     * Get account restrictions for given array of addresses
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictionsFromAccounts(AccountIds accountIds, Handler<AsyncResult<List<AccountRestrictionsInfoDTO>>> resultHandler) {
        delegate.getAccountRestrictionsFromAccounts(accountIds, resultHandler);
    }

    /**
     * Get account restrictions for given array of addresses
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<AccountRestrictionsInfoDTO>> rxGetAccountRestrictionsFromAccounts(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountRestrictionsFromAccounts(accountIds, fut);
        }));
    }

    public static RestrictionAccountRoutesApi newInstance(io.nem.sdk.openapi.vertx.api.RestrictionAccountRoutesApi arg) {
        return arg != null ? new RestrictionAccountRoutesApi(arg) : null;
    }
}
