package io.nem.sdk.openapi.vertx.api.rxjava;

import io.nem.sdk.openapi.vertx.model.ServerInfoDTO;
import io.nem.sdk.openapi.vertx.model.StorageInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-01T18:24:23.294947664-03:00[America/Argentina/Buenos_Aires]")
public class DiagnosticRoutesApi {

	private final io.nem.sdk.openapi.vertx.api.DiagnosticRoutesApi delegate;

	public DiagnosticRoutesApi(io.nem.sdk.openapi.vertx.api.DiagnosticRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.sdk.openapi.vertx.api.DiagnosticRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the storage information of the node
     * Returns diagnostic information about the node storage.
     * @param resultHandler Asynchronous result handler
     */
    public void getDiagnosticStorage(Handler<AsyncResult<StorageInfoDTO>> resultHandler) {
        delegate.getDiagnosticStorage(resultHandler);
    }

    /**
     * Get the storage information of the node
     * Returns diagnostic information about the node storage.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<StorageInfoDTO> rxGetDiagnosticStorage() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getDiagnosticStorage(fut);
        }));
    }
    /**
     * Get the version of the running rest component
     * Returns the version of the running catapult-rest component.
     * @param resultHandler Asynchronous result handler
     */
    public void getServerInfo(Handler<AsyncResult<ServerInfoDTO>> resultHandler) {
        delegate.getServerInfo(resultHandler);
    }

    /**
     * Get the version of the running rest component
     * Returns the version of the running catapult-rest component.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<ServerInfoDTO> rxGetServerInfo() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getServerInfo(fut);
        }));
    }

    public static DiagnosticRoutesApi newInstance(io.nem.sdk.openapi.vertx.api.DiagnosticRoutesApi arg) {
        return arg != null ? new DiagnosticRoutesApi(arg) : null;
    }
}
