package io.nem.sdk.openapi.vertx.api.rxjava;

import io.nem.sdk.openapi.vertx.model.ChainScoreDTO;
import io.nem.sdk.openapi.vertx.model.HeightInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-01T18:24:23.294947664-03:00[America/Argentina/Buenos_Aires]")
public class ChainRoutesApi {

	private final io.nem.sdk.openapi.vertx.api.ChainRoutesApi delegate;

	public ChainRoutesApi(io.nem.sdk.openapi.vertx.api.ChainRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.sdk.openapi.vertx.api.ChainRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the current height of the chain
     * Returns the current height of the blockchain.
     * @param resultHandler Asynchronous result handler
     */
    public void getChainHeight(Handler<AsyncResult<HeightInfoDTO>> resultHandler) {
        delegate.getChainHeight(resultHandler);
    }

    /**
     * Get the current height of the chain
     * Returns the current height of the blockchain.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<HeightInfoDTO> rxGetChainHeight() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getChainHeight(fut);
        }));
    }
    /**
     * Get the current score of the chain
     * Gets the current score of the blockchain. The higher the score, the better the chain. During synchronization, nodes try to get the best blockchain in the network.  The score for a block is derived from its difficulty and the time (in seconds) that has elapsed since the last block:      block score &#x3D; difficulty − time elapsed since last block 
     * @param resultHandler Asynchronous result handler
     */
    public void getChainScore(Handler<AsyncResult<ChainScoreDTO>> resultHandler) {
        delegate.getChainScore(resultHandler);
    }

    /**
     * Get the current score of the chain
     * Gets the current score of the blockchain. The higher the score, the better the chain. During synchronization, nodes try to get the best blockchain in the network.  The score for a block is derived from its difficulty and the time (in seconds) that has elapsed since the last block:      block score &#x3D; difficulty − time elapsed since last block 
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<ChainScoreDTO> rxGetChainScore() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getChainScore(fut);
        }));
    }

    public static ChainRoutesApi newInstance(io.nem.sdk.openapi.vertx.api.ChainRoutesApi arg) {
        return arg != null ? new ChainRoutesApi(arg) : null;
    }
}
