package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.AnnounceTransactionInfoDTO;
import io.nem.sdk.openapi.vertx.model.Cosignature;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.TransactionHashes;
import io.nem.sdk.openapi.vertx.model.TransactionIds;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.sdk.openapi.vertx.model.TransactionStatusDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface TransactionRoutesApi {

    void announceCosignatureTransaction(Cosignature cosignature, Handler<AsyncResult<AnnounceTransactionInfoDTO>> handler);

    void announcePartialTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> handler);

    void announceTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> handler);

    void getTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> handler);

    void getTransactionStatus(String hash, Handler<AsyncResult<TransactionStatusDTO>> handler);

    void getTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getTransactionsStatuses(TransactionHashes transactionHashes, Handler<AsyncResult<List<TransactionStatusDTO>>> handler);

}
