package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.StatementsDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.nem.sdk.openapi.vertx.invoker.Configuration;
import io.nem.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-01T18:24:23.294947664-03:00[America/Argentina/Buenos_Aires]")
public class ReceiptRoutesApiImpl implements ReceiptRoutesApi {

    private ApiClient apiClient;

    public ReceiptRoutesApiImpl() {
        this(null);
    }

    public ReceiptRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get receipts from a block
     * Returns the receipts linked to a block.
     * @param height Block height.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockReceipts(java.math.BigInteger height, Handler<AsyncResult<StatementsDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlockReceipts"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/block/{height}/receipts".replaceAll("\\{" + "height" + "\\}", height.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<StatementsDTO> localVarReturnType = new TypeReference<StatementsDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
     * @param height Block height.  (required)
     * @param hash Receipt hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleReceipts(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getMerkleReceipts"));
            return;
        }
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getMerkleReceipts"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/block/{height}/receipt/{hash}/merkle".replaceAll("\\{" + "height" + "\\}", height.toString()).replaceAll("\\{" + "hash" + "\\}", hash.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MerkleProofInfoDTO> localVarReturnType = new TypeReference<MerkleProofInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
