package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.MultisigAccountGraphInfoDTO;
import io.nem.sdk.openapi.vertx.model.MultisigAccountInfoDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.nem.sdk.openapi.vertx.invoker.Configuration;
import io.nem.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-01T18:24:23.294947664-03:00[America/Argentina/Buenos_Aires]")
public class MultisigRoutesApiImpl implements MultisigRoutesApi {

    private ApiClient apiClient;

    public MultisigRoutesApiImpl() {
        this(null);
    }

    public MultisigRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param accountId Account public key or address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisig(String accountId, Handler<AsyncResult<MultisigAccountInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountMultisig"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/multisig".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MultisigAccountInfoDTO> localVarReturnType = new TypeReference<MultisigAccountInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param accountId Account public key or address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisigGraph(String accountId, Handler<AsyncResult<List<MultisigAccountGraphInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountMultisigGraph"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/multisig/graph".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<MultisigAccountGraphInfoDTO>> localVarReturnType = new TypeReference<List<MultisigAccountGraphInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
