package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.MosaicIds;
import io.nem.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.nem.sdk.openapi.vertx.model.MosaicsInfoDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface MosaicRoutesApi {

    void getMosaic(String mosaicId, Handler<AsyncResult<MosaicInfoDTO>> handler);

    void getMosaics(MosaicIds mosaicIds, Handler<AsyncResult<List<MosaicInfoDTO>>> handler);

    void getMosaicsFromAccount(String accountId, Handler<AsyncResult<MosaicsInfoDTO>> handler);

    void getMosaicsFromAccounts(AccountIds accountIds, Handler<AsyncResult<MosaicsInfoDTO>> handler);

}
