package io.nem.sdk.openapi.vertx.api;

import io.nem.sdk.openapi.vertx.model.AccountIds;
import io.nem.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.sdk.openapi.vertx.model.ModelError;
import io.nem.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.sdk.openapi.vertx.model.TransactionTypeEnum;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.sdk.openapi.vertx.invoker.ApiException;
import io.nem.sdk.openapi.vertx.invoker.Configuration;
import io.nem.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-01T18:24:23.294947664-03:00[America/Argentina/Buenos_Aires]")
public class AccountRoutesApiImpl implements AccountRoutesApi {

    private ApiClient apiClient;

    public AccountRoutesApiImpl() {
        this(null);
    }

    public AccountRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get confirmed transactions
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountConfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountConfirmedTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "type", type));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get incoming transactions
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountIncomingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountIncomingTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/incoming".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "type", type));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountInfo(String accountId, Handler<AsyncResult<AccountInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountInfo"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AccountInfoDTO> localVarReturnType = new TypeReference<AccountInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get outgoing transactions
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountOutgoingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountOutgoingTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/outgoing".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "type", type));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get aggregate bonded transactions information
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountPartialTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountPartialTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/partial".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "type", type));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get unconfirmed transactions
     * Gets the array of transactions not included in a block where an account is the sender or receiver.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountUnconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountUnconfirmedTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/unconfirmed".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "type", type));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsInfo(AccountIds accountIds, Handler<AsyncResult<List<AccountInfoDTO>>> resultHandler) {
        Object localVarBody = accountIds;
        
        // create path and map variables
        String localVarPath = "/account";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<AccountInfoDTO>> localVarReturnType = new TypeReference<List<AccountInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
