/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to lock funds before sending an aggregate bonded transaction.")
public class HashLockTransactionDTO {
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @SerializedName(value="signerPublicKey")
    private String signerPublicKey;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private NetworkTypeEnum network;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_MAX_FEE = "maxFee";
    @SerializedName(value="maxFee")
    private BigInteger maxFee = null;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private BigInteger deadline = null;
    public static final String SERIALIZED_NAME_MOSAIC_ID = "mosaicId";
    @SerializedName(value="mosaicId")
    private String mosaicId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigInteger amount = null;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private BigInteger duration = null;
    public static final String SERIALIZED_NAME_HASH = "hash";
    @SerializedName(value="hash")
    private String hash;

    public HashLockTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public HashLockTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public HashLockTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public HashLockTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public HashLockTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public HashLockTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public HashLockTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public HashLockTransactionDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public HashLockTransactionDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public HashLockTransactionDTO duration(BigInteger duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDuration() {
        return this.duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public HashLockTransactionDTO hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashLockTransactionDTO hashLockTransactionDTO = (HashLockTransactionDTO)o;
        return Objects.equals(this.signature, hashLockTransactionDTO.signature) && Objects.equals(this.signerPublicKey, hashLockTransactionDTO.signerPublicKey) && Objects.equals(this.version, hashLockTransactionDTO.version) && Objects.equals((Object)this.network, (Object)hashLockTransactionDTO.network) && Objects.equals(this.type, hashLockTransactionDTO.type) && Objects.equals(this.maxFee, hashLockTransactionDTO.maxFee) && Objects.equals(this.deadline, hashLockTransactionDTO.deadline) && Objects.equals(this.mosaicId, hashLockTransactionDTO.mosaicId) && Objects.equals(this.amount, hashLockTransactionDTO.amount) && Objects.equals(this.duration, hashLockTransactionDTO.duration) && Objects.equals(this.hash, hashLockTransactionDTO.hash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.mosaicId, this.amount, this.duration, this.hash});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HashLockTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

