/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.16
 *
 * The version of the OpenAPI document: 0.8.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicAddressRestrictionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicGlobalRestrictionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicIds;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestrictionMosaicRoutesApi {
    private ApiClient localVarApiClient;

    public RestrictionMosaicRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RestrictionMosaicRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getMosaicAddressRestriction
     * @param mosaicId Mosaic identifier. (required)
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicAddressRestrictionCall(String mosaicId, String accountId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/restrictions/mosaic/{mosaicId}/address/{accountId}"
            .replaceAll("\\{" + "mosaicId" + "\\}", localVarApiClient.escapeString(mosaicId.toString()))
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicAddressRestrictionValidateBeforeCall(String mosaicId, String accountId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicAddressRestriction(Async)");
        }
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getMosaicAddressRestriction(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicAddressRestrictionCall(mosaicId, accountId, _callback);
        return localVarCall;

    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifier.
     * Get mosaic address restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return MosaicAddressRestrictionDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MosaicAddressRestrictionDTO getMosaicAddressRestriction(String mosaicId, String accountId) throws ApiException {
        ApiResponse<MosaicAddressRestrictionDTO> localVarResp = getMosaicAddressRestrictionWithHttpInfo(mosaicId, accountId);
        return localVarResp.getData();
    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifier.
     * Get mosaic address restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return ApiResponse&lt;MosaicAddressRestrictionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MosaicAddressRestrictionDTO> getMosaicAddressRestrictionWithHttpInfo(String mosaicId, String accountId) throws ApiException {
        okhttp3.Call localVarCall = getMosaicAddressRestrictionValidateBeforeCall(mosaicId, accountId, null);
        Type localVarReturnType = new TypeToken<MosaicAddressRestrictionDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifier. (asynchronously)
     * Get mosaic address restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicAddressRestrictionAsync(String mosaicId, String accountId, final ApiCallback<MosaicAddressRestrictionDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicAddressRestrictionValidateBeforeCall(mosaicId, accountId, _callback);
        Type localVarReturnType = new TypeToken<MosaicAddressRestrictionDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMosaicAddressRestrictions
     * @param mosaicId Mosaic identifier. (required)
     * @param accountIds  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicAddressRestrictionsCall(String mosaicId, AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountIds;

        // create path and map variables
        String localVarPath = "/restrictions/mosaic/{mosaicId}"
            .replaceAll("\\{" + "mosaicId" + "\\}", localVarApiClient.escapeString(mosaicId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicAddressRestrictionsValidateBeforeCall(String mosaicId, AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicAddressRestrictions(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicAddressRestrictionsCall(mosaicId, accountIds, _callback);
        return localVarCall;

    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifiers array.
     * Get mosaic address restrictions.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountIds  (optional)
     * @return List&lt;MosaicAddressRestrictionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<MosaicAddressRestrictionDTO> getMosaicAddressRestrictions(String mosaicId, AccountIds accountIds) throws ApiException {
        ApiResponse<List<MosaicAddressRestrictionDTO>> localVarResp = getMosaicAddressRestrictionsWithHttpInfo(mosaicId, accountIds);
        return localVarResp.getData();
    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifiers array.
     * Get mosaic address restrictions.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountIds  (optional)
     * @return ApiResponse&lt;List&lt;MosaicAddressRestrictionDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<MosaicAddressRestrictionDTO>> getMosaicAddressRestrictionsWithHttpInfo(String mosaicId, AccountIds accountIds) throws ApiException {
        okhttp3.Call localVarCall = getMosaicAddressRestrictionsValidateBeforeCall(mosaicId, accountIds, null);
        Type localVarReturnType = new TypeToken<List<MosaicAddressRestrictionDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifiers array. (asynchronously)
     * Get mosaic address restrictions.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountIds  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicAddressRestrictionsAsync(String mosaicId, AccountIds accountIds, final ApiCallback<List<MosaicAddressRestrictionDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicAddressRestrictionsValidateBeforeCall(mosaicId, accountIds, _callback);
        Type localVarReturnType = new TypeToken<List<MosaicAddressRestrictionDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMosaicGlobalRestriction
     * @param mosaicId Mosaic identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicGlobalRestrictionCall(String mosaicId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/restrictions/mosaic/{mosaicId}"
            .replaceAll("\\{" + "mosaicId" + "\\}", localVarApiClient.escapeString(mosaicId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicGlobalRestrictionValidateBeforeCall(String mosaicId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicGlobalRestriction(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicGlobalRestrictionCall(mosaicId, _callback);
        return localVarCall;

    }

    /**
     * Get mosaic global restriction for a given mosaic identifier.
     * Get mosaic global restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @return MosaicGlobalRestrictionDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MosaicGlobalRestrictionDTO getMosaicGlobalRestriction(String mosaicId) throws ApiException {
        ApiResponse<MosaicGlobalRestrictionDTO> localVarResp = getMosaicGlobalRestrictionWithHttpInfo(mosaicId);
        return localVarResp.getData();
    }

    /**
     * Get mosaic global restriction for a given mosaic identifier.
     * Get mosaic global restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @return ApiResponse&lt;MosaicGlobalRestrictionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MosaicGlobalRestrictionDTO> getMosaicGlobalRestrictionWithHttpInfo(String mosaicId) throws ApiException {
        okhttp3.Call localVarCall = getMosaicGlobalRestrictionValidateBeforeCall(mosaicId, null);
        Type localVarReturnType = new TypeToken<MosaicGlobalRestrictionDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get mosaic global restriction for a given mosaic identifier. (asynchronously)
     * Get mosaic global restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicGlobalRestrictionAsync(String mosaicId, final ApiCallback<MosaicGlobalRestrictionDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicGlobalRestrictionValidateBeforeCall(mosaicId, _callback);
        Type localVarReturnType = new TypeToken<MosaicGlobalRestrictionDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMosaicGlobalRestrictions
     * @param mosaicIds  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicGlobalRestrictionsCall(MosaicIds mosaicIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = mosaicIds;

        // create path and map variables
        String localVarPath = "/restrictions/mosaic";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicGlobalRestrictionsValidateBeforeCall(MosaicIds mosaicIds, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicIds' is set
        if (mosaicIds == null) {
            throw new ApiException("Missing the required parameter 'mosaicIds' when calling getMosaicGlobalRestrictions(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicGlobalRestrictionsCall(mosaicIds, _callback);
        return localVarCall;

    }

    /**
     * Get mosaic global restrictions for an array of mosaics.
     * Get mosaic global restrictions.
     * @param mosaicIds  (required)
     * @return List&lt;MosaicGlobalRestrictionDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<MosaicGlobalRestrictionDTO> getMosaicGlobalRestrictions(MosaicIds mosaicIds) throws ApiException {
        ApiResponse<List<MosaicGlobalRestrictionDTO>> localVarResp = getMosaicGlobalRestrictionsWithHttpInfo(mosaicIds);
        return localVarResp.getData();
    }

    /**
     * Get mosaic global restrictions for an array of mosaics.
     * Get mosaic global restrictions.
     * @param mosaicIds  (required)
     * @return ApiResponse&lt;List&lt;MosaicGlobalRestrictionDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<MosaicGlobalRestrictionDTO>> getMosaicGlobalRestrictionsWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        okhttp3.Call localVarCall = getMosaicGlobalRestrictionsValidateBeforeCall(mosaicIds, null);
        Type localVarReturnType = new TypeToken<List<MosaicGlobalRestrictionDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get mosaic global restrictions for an array of mosaics. (asynchronously)
     * Get mosaic global restrictions.
     * @param mosaicIds  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicGlobalRestrictionsAsync(MosaicIds mosaicIds, final ApiCallback<List<MosaicGlobalRestrictionDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicGlobalRestrictionsValidateBeforeCall(mosaicIds, _callback);
        Type localVarReturnType = new TypeToken<List<MosaicGlobalRestrictionDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
