/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.api;

import com.google.gson.reflect.TypeToken;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionTypeEnum;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AccountRoutesApi {
    private ApiClient localVarApiClient;

    public AccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAccountConfirmedTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountConfirmedTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountConfirmedTransactions(Async)");
        }
        Call localVarCall = this.getAccountConfirmedTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> getAccountConfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.getAccountConfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountConfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Call localVarCall = this.getAccountConfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountConfirmedTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountConfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountIncomingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/incoming".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountIncomingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountIncomingTransactions(Async)");
        }
        Call localVarCall = this.getAccountIncomingTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> getAccountIncomingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.getAccountIncomingTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountIncomingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Call localVarCall = this.getAccountIncomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountIncomingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountIncomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountInfoCall(String accountId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountInfoValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountInfo(Async)");
        }
        Call localVarCall = this.getAccountInfoCall(accountId, _callback);
        return localVarCall;
    }

    public AccountInfoDTO getAccountInfo(String accountId) throws ApiException {
        ApiResponse<AccountInfoDTO> localVarResp = this.getAccountInfoWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    public ApiResponse<AccountInfoDTO> getAccountInfoWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.getAccountInfoValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountInfoAsync(String accountId, ApiCallback<AccountInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getAccountInfoValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountOutgoingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/outgoing".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountOutgoingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountOutgoingTransactions(Async)");
        }
        Call localVarCall = this.getAccountOutgoingTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> getAccountOutgoingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.getAccountOutgoingTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountOutgoingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Call localVarCall = this.getAccountOutgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountOutgoingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountOutgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountPartialTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/partial".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountPartialTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountPartialTransactions(Async)");
        }
        Call localVarCall = this.getAccountPartialTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> getAccountPartialTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.getAccountPartialTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountPartialTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Call localVarCall = this.getAccountPartialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountPartialTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountPartialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountUnconfirmedTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/unconfirmed".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountUnconfirmedTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountUnconfirmedTransactions(Async)");
        }
        Call localVarCall = this.getAccountUnconfirmedTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> getAccountUnconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.getAccountUnconfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountUnconfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Call localVarCall = this.getAccountUnconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountUnconfirmedTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountUnconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountsInfoCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountsInfoValidateBeforeCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAccountsInfoCall(accountIds, _callback);
        return localVarCall;
    }

    public List<AccountInfoDTO> getAccountsInfo(AccountIds accountIds) throws ApiException {
        ApiResponse<List<AccountInfoDTO>> localVarResp = this.getAccountsInfoWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    public ApiResponse<List<AccountInfoDTO>> getAccountsInfoWithHttpInfo(AccountIds accountIds) throws ApiException {
        Call localVarCall = this.getAccountsInfoValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountsInfoAsync(AccountIds accountIds, ApiCallback<List<AccountInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountsInfoValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

