/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.11
 *
 * The version of the OpenAPI document: 0.8.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucketis created. Each bucket influences at most five importance recalculations. 
 */
@ApiModel(description = "Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucketis created. Each bucket influences at most five importance recalculations. ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-11T18:57:47.444Z[UTC]")
public class ActivityBucketDTO {
  public static final String SERIALIZED_NAME_START_HEIGHT = "startHeight";
  @SerializedName(SERIALIZED_NAME_START_HEIGHT)
  private java.math.BigInteger startHeight = null;

  public static final String SERIALIZED_NAME_TOTAL_FEES_PAID = "totalFeesPaid";
  @SerializedName(SERIALIZED_NAME_TOTAL_FEES_PAID)
  private Long totalFeesPaid;

  public static final String SERIALIZED_NAME_BENEFICIARY_COUNT = "beneficiaryCount";
  @SerializedName(SERIALIZED_NAME_BENEFICIARY_COUNT)
  private Integer beneficiaryCount;

  public static final String SERIALIZED_NAME_RAW_SCORE = "rawScore";
  @SerializedName(SERIALIZED_NAME_RAW_SCORE)
  private Long rawScore;

  public ActivityBucketDTO startHeight(java.math.BigInteger startHeight) {
    this.startHeight = startHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return startHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  public java.math.BigInteger getStartHeight() {
    return startHeight;
  }

  public void setStartHeight(java.math.BigInteger startHeight) {
    this.startHeight = startHeight;
  }

  public ActivityBucketDTO totalFeesPaid(Long totalFeesPaid) {
    this.totalFeesPaid = totalFeesPaid;
    return this;
  }

   /**
   * Fees paid by the account for this bucket.
   * @return totalFeesPaid
  **/
  @ApiModelProperty(required = true, value = "Fees paid by the account for this bucket.")
  public Long getTotalFeesPaid() {
    return totalFeesPaid;
  }

  public void setTotalFeesPaid(Long totalFeesPaid) {
    this.totalFeesPaid = totalFeesPaid;
  }

  public ActivityBucketDTO beneficiaryCount(Integer beneficiaryCount) {
    this.beneficiaryCount = beneficiaryCount;
    return this;
  }

   /**
   * Number of times the account has been a beneficiary for this bucket.
   * @return beneficiaryCount
  **/
  @ApiModelProperty(required = true, value = "Number of times the account has been a beneficiary for this bucket.")
  public Integer getBeneficiaryCount() {
    return beneficiaryCount;
  }

  public void setBeneficiaryCount(Integer beneficiaryCount) {
    this.beneficiaryCount = beneficiaryCount;
  }

  public ActivityBucketDTO rawScore(Long rawScore) {
    this.rawScore = rawScore;
    return this;
  }

   /**
   * Importance score for this bucket. This is taken into account to calculate the latest account importance.
   * @return rawScore
  **/
  @ApiModelProperty(required = true, value = "Importance score for this bucket. This is taken into account to calculate the latest account importance.")
  public Long getRawScore() {
    return rawScore;
  }

  public void setRawScore(Long rawScore) {
    this.rawScore = rawScore;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivityBucketDTO activityBucketDTO = (ActivityBucketDTO) o;
    return Objects.equals(this.startHeight, activityBucketDTO.startHeight) &&
        Objects.equals(this.totalFeesPaid, activityBucketDTO.totalFeesPaid) &&
        Objects.equals(this.beneficiaryCount, activityBucketDTO.beneficiaryCount) &&
        Objects.equals(this.rawScore, activityBucketDTO.rawScore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startHeight, totalFeesPaid, beneficiaryCount, rawScore);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivityBucketDTO {\n");
    sb.append("    startHeight: ").append(toIndentedString(startHeight)).append("\n");
    sb.append("    totalFeesPaid: ").append(toIndentedString(totalFeesPaid)).append("\n");
    sb.append("    beneficiaryCount: ").append(toIndentedString(beneficiaryCount)).append("\n");
    sb.append("    rawScore: ").append(toIndentedString(rawScore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

