/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.11
 *
 * The version of the OpenAPI document: 0.8.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.MetadataDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MetadataEntriesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataRoutesApi {
    private ApiClient localVarApiClient;

    public MetadataRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetadataRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAccountMetadata
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMetadataCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/account/{accountId}"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountMetadataValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMetadata(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountMetadataCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return MetadataEntriesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataEntriesDTO getAccountMetadata(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = getAccountMetadataWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;MetadataEntriesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataEntriesDTO> getAccountMetadataWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = getAccountMetadataValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get account metadata (asynchronously)
     * Returns the account metadata given an account id.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMetadataAsync(String accountId, Integer pageSize, String id, String ordering, final ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountMetadataValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountMetadataByKey
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMetadataByKeyCall(String accountId, String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/account/{accountId}/key/{key}"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountMetadataByKeyValidateBeforeCall(String accountId, String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMetadataByKey(Async)");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getAccountMetadataByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountMetadataByKeyCall(accountId, key, _callback);
        return localVarCall;

    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id and a key.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @return MetadataEntriesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataEntriesDTO getAccountMetadataByKey(String accountId, String key) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = getAccountMetadataByKeyWithHttpInfo(accountId, key);
        return localVarResp.getData();
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id and a key.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @return ApiResponse&lt;MetadataEntriesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataEntriesDTO> getAccountMetadataByKeyWithHttpInfo(String accountId, String key) throws ApiException {
        okhttp3.Call localVarCall = getAccountMetadataByKeyValidateBeforeCall(accountId, key, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get account metadata (asynchronously)
     * Returns the account metadata given an account id and a key.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMetadataByKeyAsync(String accountId, String key, final ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountMetadataByKeyValidateBeforeCall(accountId, key, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountMetadataByKeyAndSender
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMetadataByKeyAndSenderCall(String accountId, String key, String publicKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/account/{accountId}/key/{key}/sender/{publicKey}"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "publicKey" + "\\}", localVarApiClient.escapeString(publicKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountMetadataByKeyAndSenderValidateBeforeCall(String accountId, String key, String publicKey, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMetadataByKeyAndSender(Async)");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender(Async)");
        }
        
        // verify the required parameter 'publicKey' is set
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getAccountMetadataByKeyAndSender(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountMetadataByKeyAndSenderCall(accountId, key, publicKey, _callback);
        return localVarCall;

    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id, a key, and a sender.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return MetadataDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataDTO getAccountMetadataByKeyAndSender(String accountId, String key, String publicKey) throws ApiException {
        ApiResponse<MetadataDTO> localVarResp = getAccountMetadataByKeyAndSenderWithHttpInfo(accountId, key, publicKey);
        return localVarResp.getData();
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id, a key, and a sender.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return ApiResponse&lt;MetadataDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataDTO> getAccountMetadataByKeyAndSenderWithHttpInfo(String accountId, String key, String publicKey) throws ApiException {
        okhttp3.Call localVarCall = getAccountMetadataByKeyAndSenderValidateBeforeCall(accountId, key, publicKey, null);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get account metadata (asynchronously)
     * Returns the account metadata given an account id, a key, and a sender.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMetadataByKeyAndSenderAsync(String accountId, String key, String publicKey, final ApiCallback<MetadataDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountMetadataByKeyAndSenderValidateBeforeCall(accountId, key, publicKey, _callback);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMosaicMetadata
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicMetadataCall(String mosaicId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/mosaic/{mosaicId}"
            .replaceAll("\\{" + "mosaicId" + "\\}", localVarApiClient.escapeString(mosaicId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicMetadataValidateBeforeCall(String mosaicId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicMetadata(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicMetadataCall(mosaicId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return MetadataEntriesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataEntriesDTO getMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = getMosaicMetadataWithHttpInfo(mosaicId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;MetadataEntriesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataEntriesDTO> getMosaicMetadataWithHttpInfo(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = getMosaicMetadataValidateBeforeCall(mosaicId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get mosaic metadata (asynchronously)
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicMetadataAsync(String mosaicId, Integer pageSize, String id, String ordering, final ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicMetadataValidateBeforeCall(mosaicId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMosaicMetadataByKey
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicMetadataByKeyCall(String mosaicId, String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}"
            .replaceAll("\\{" + "mosaicId" + "\\}", localVarApiClient.escapeString(mosaicId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicMetadataByKeyValidateBeforeCall(String mosaicId, String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey(Async)");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getMosaicMetadataByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicMetadataByKeyCall(mosaicId, key, _callback);
        return localVarCall;

    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @return MetadataEntriesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataEntriesDTO getMosaicMetadataByKey(String mosaicId, String key) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = getMosaicMetadataByKeyWithHttpInfo(mosaicId, key);
        return localVarResp.getData();
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @return ApiResponse&lt;MetadataEntriesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataEntriesDTO> getMosaicMetadataByKeyWithHttpInfo(String mosaicId, String key) throws ApiException {
        okhttp3.Call localVarCall = getMosaicMetadataByKeyValidateBeforeCall(mosaicId, key, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get mosaic metadata (asynchronously)
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicMetadataByKeyAsync(String mosaicId, String key, final ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicMetadataByKeyValidateBeforeCall(mosaicId, key, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMosaicMetadataByKeyAndSender
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicMetadataByKeyAndSenderCall(String mosaicId, String key, String publicKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{publicKey}"
            .replaceAll("\\{" + "mosaicId" + "\\}", localVarApiClient.escapeString(mosaicId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "publicKey" + "\\}", localVarApiClient.escapeString(publicKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicMetadataByKeyAndSenderValidateBeforeCall(String mosaicId, String key, String publicKey, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender(Async)");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender(Async)");
        }
        
        // verify the required parameter 'publicKey' is set
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getMosaicMetadataByKeyAndSender(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicMetadataByKeyAndSenderCall(mosaicId, key, publicKey, _callback);
        return localVarCall;

    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return MetadataDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataDTO getMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey) throws ApiException {
        ApiResponse<MetadataDTO> localVarResp = getMosaicMetadataByKeyAndSenderWithHttpInfo(mosaicId, key, publicKey);
        return localVarResp.getData();
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return ApiResponse&lt;MetadataDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataDTO> getMosaicMetadataByKeyAndSenderWithHttpInfo(String mosaicId, String key, String publicKey) throws ApiException {
        okhttp3.Call localVarCall = getMosaicMetadataByKeyAndSenderValidateBeforeCall(mosaicId, key, publicKey, null);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get mosaic metadata (asynchronously)
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicMetadataByKeyAndSenderAsync(String mosaicId, String key, String publicKey, final ApiCallback<MetadataDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicMetadataByKeyAndSenderValidateBeforeCall(mosaicId, key, publicKey, _callback);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNamespaceMetadata
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceMetadataCall(String namespaceId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/namespace/{namespaceId}"
            .replaceAll("\\{" + "namespaceId" + "\\}", localVarApiClient.escapeString(namespaceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNamespaceMetadataValidateBeforeCall(String namespaceId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespaceMetadata(Async)");
        }
        

        okhttp3.Call localVarCall = getNamespaceMetadataCall(namespaceId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return MetadataEntriesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataEntriesDTO getNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = getNamespaceMetadataWithHttpInfo(namespaceId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;MetadataEntriesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataWithHttpInfo(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = getNamespaceMetadataValidateBeforeCall(namespaceId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get namespace metadata (asynchronously)
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceMetadataAsync(String namespaceId, Integer pageSize, String id, String ordering, final ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNamespaceMetadataValidateBeforeCall(namespaceId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNamespaceMetadataByKey
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceMetadataByKeyCall(String namespaceId, String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}"
            .replaceAll("\\{" + "namespaceId" + "\\}", localVarApiClient.escapeString(namespaceId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNamespaceMetadataByKeyValidateBeforeCall(String namespaceId, String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey(Async)");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getNamespaceMetadataByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getNamespaceMetadataByKeyCall(namespaceId, key, _callback);
        return localVarCall;

    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @return MetadataEntriesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataEntriesDTO getNamespaceMetadataByKey(String namespaceId, String key) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = getNamespaceMetadataByKeyWithHttpInfo(namespaceId, key);
        return localVarResp.getData();
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @return ApiResponse&lt;MetadataEntriesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataByKeyWithHttpInfo(String namespaceId, String key) throws ApiException {
        okhttp3.Call localVarCall = getNamespaceMetadataByKeyValidateBeforeCall(namespaceId, key, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get namespace metadata (asynchronously)
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceMetadataByKeyAsync(String namespaceId, String key, final ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNamespaceMetadataByKeyValidateBeforeCall(namespaceId, key, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNamespaceMetadataByKeyAndSender
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceMetadataByKeyAndSenderCall(String namespaceId, String key, String publicKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{publicKey}"
            .replaceAll("\\{" + "namespaceId" + "\\}", localVarApiClient.escapeString(namespaceId.toString()))
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "publicKey" + "\\}", localVarApiClient.escapeString(publicKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNamespaceMetadataByKeyAndSenderValidateBeforeCall(String namespaceId, String key, String publicKey, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender(Async)");
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender(Async)");
        }
        
        // verify the required parameter 'publicKey' is set
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getNamespaceMetadataByKeyAndSender(Async)");
        }
        

        okhttp3.Call localVarCall = getNamespaceMetadataByKeyAndSenderCall(namespaceId, key, publicKey, _callback);
        return localVarCall;

    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return MetadataDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MetadataDTO getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey) throws ApiException {
        ApiResponse<MetadataDTO> localVarResp = getNamespaceMetadataByKeyAndSenderWithHttpInfo(namespaceId, key, publicKey);
        return localVarResp.getData();
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return ApiResponse&lt;MetadataDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MetadataDTO> getNamespaceMetadataByKeyAndSenderWithHttpInfo(String namespaceId, String key, String publicKey) throws ApiException {
        okhttp3.Call localVarCall = getNamespaceMetadataByKeyAndSenderValidateBeforeCall(namespaceId, key, publicKey, null);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get namespace metadata (asynchronously)
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceMetadataByKeyAndSenderAsync(String namespaceId, String key, String publicKey, final ApiCallback<MetadataDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNamespaceMetadataByKeyAndSenderValidateBeforeCall(namespaceId, key, publicKey, _callback);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
