/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.11
 *
 * The version of the OpenAPI document: 0.8.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionTypeEnum;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountRoutesApi {
    private ApiClient localVarApiClient;

    public AccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAccountConfirmedTransactions
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountConfirmedTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountConfirmedTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountConfirmedTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountConfirmedTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;

    }

    /**
     * Get confirmed transactions
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> getAccountConfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = getAccountConfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    /**
     * Get confirmed transactions
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> getAccountConfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        okhttp3.Call localVarCall = getAccountConfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get confirmed transactions (asynchronously)
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountConfirmedTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountConfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountIncomingTransactions
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountIncomingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/incoming"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountIncomingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountIncomingTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountIncomingTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;

    }

    /**
     * Get incoming transactions
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> getAccountIncomingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = getAccountIncomingTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    /**
     * Get incoming transactions
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> getAccountIncomingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        okhttp3.Call localVarCall = getAccountIncomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get incoming transactions (asynchronously)
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountIncomingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountIncomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountInfo
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountInfoCall(String accountId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountInfoValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountInfo(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountInfoCall(accountId, _callback);
        return localVarCall;

    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return AccountInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AccountInfoDTO getAccountInfo(String accountId) throws ApiException {
        ApiResponse<AccountInfoDTO> localVarResp = getAccountInfoWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return ApiResponse&lt;AccountInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountInfoDTO> getAccountInfoWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getAccountInfoValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get account information (asynchronously)
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountInfoAsync(String accountId, final ApiCallback<AccountInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountInfoValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountOutgoingTransactions
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountOutgoingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/outgoing"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountOutgoingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountOutgoingTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountOutgoingTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;

    }

    /**
     * Get outgoing transactions
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> getAccountOutgoingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = getAccountOutgoingTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    /**
     * Get outgoing transactions
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> getAccountOutgoingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        okhttp3.Call localVarCall = getAccountOutgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get outgoing transactions (asynchronously)
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountOutgoingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountOutgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountPartialTransactions
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountPartialTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/partial"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountPartialTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountPartialTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountPartialTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;

    }

    /**
     * Get aggregate bonded transactions information
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> getAccountPartialTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = getAccountPartialTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    /**
     * Get aggregate bonded transactions information
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> getAccountPartialTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        okhttp3.Call localVarCall = getAccountPartialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get aggregate bonded transactions information (asynchronously)
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountPartialTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountPartialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountUnconfirmedTransactions
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountUnconfirmedTransactionsCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/unconfirmed"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountUnconfirmedTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountUnconfirmedTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountUnconfirmedTransactionsCall(accountId, pageSize, id, ordering, type, _callback);
        return localVarCall;

    }

    /**
     * Get unconfirmed transactions
     * Gets the array of transactions not included in a block where an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> getAccountUnconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = getAccountUnconfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type);
        return localVarResp.getData();
    }

    /**
     * Get unconfirmed transactions
     * Gets the array of transactions not included in a block where an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> getAccountUnconfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        okhttp3.Call localVarCall = getAccountUnconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get unconfirmed transactions (asynchronously)
     * Gets the array of transactions not included in a block where an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountUnconfirmedTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountUnconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, type, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountsInfo
     * @param accountIds  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsInfoCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountIds;

        // create path and map variables
        String localVarPath = "/account";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountsInfoValidateBeforeCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAccountsInfoCall(accountIds, _callback);
        return localVarCall;

    }

    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @return List&lt;AccountInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<AccountInfoDTO> getAccountsInfo(AccountIds accountIds) throws ApiException {
        ApiResponse<List<AccountInfoDTO>> localVarResp = getAccountsInfoWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @return ApiResponse&lt;List&lt;AccountInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<AccountInfoDTO>> getAccountsInfoWithHttpInfo(AccountIds accountIds) throws ApiException {
        okhttp3.Call localVarCall = getAccountsInfoValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get accounts information (asynchronously)
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsInfoAsync(AccountIds accountIds, final ApiCallback<List<AccountInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountsInfoValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
