/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.ResolutionEntryDTO;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResolutionStatementBodyDTO {
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private BigInteger height = null;
    public static final String SERIALIZED_NAME_UNRESOLVED = "unresolved";
    @SerializedName(value="unresolved")
    private Object unresolved = null;
    public static final String SERIALIZED_NAME_RESOLUTION_ENTRIES = "resolutionEntries";
    @SerializedName(value="resolutionEntries")
    private List<ResolutionEntryDTO> resolutionEntries = new ArrayList<ResolutionEntryDTO>();

    public ResolutionStatementBodyDTO height(BigInteger height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    public BigInteger getHeight() {
        return this.height;
    }

    public void setHeight(BigInteger height) {
        this.height = height;
    }

    public ResolutionStatementBodyDTO unresolved(Object unresolved) {
        this.unresolved = unresolved;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Object getUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(Object unresolved) {
        this.unresolved = unresolved;
    }

    public ResolutionStatementBodyDTO resolutionEntries(List<ResolutionEntryDTO> resolutionEntries) {
        this.resolutionEntries = resolutionEntries;
        return this;
    }

    public ResolutionStatementBodyDTO addResolutionEntriesItem(ResolutionEntryDTO resolutionEntriesItem) {
        this.resolutionEntries.add(resolutionEntriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of resolution entries linked to the unresolved namespaceId. It is an array instead of a single resolution entry since within one block the resolution might change for different sources due to alias related transactions. ")
    public List<ResolutionEntryDTO> getResolutionEntries() {
        return this.resolutionEntries;
    }

    public void setResolutionEntries(List<ResolutionEntryDTO> resolutionEntries) {
        this.resolutionEntries = resolutionEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolutionStatementBodyDTO resolutionStatementBodyDTO = (ResolutionStatementBodyDTO)o;
        return Objects.equals(this.height, resolutionStatementBodyDTO.height) && Objects.equals(this.unresolved, resolutionStatementBodyDTO.unresolved) && Objects.equals(this.resolutionEntries, resolutionStatementBodyDTO.resolutionEntries);
    }

    public int hashCode() {
        return Objects.hash(this.height, this.unresolved, this.resolutionEntries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResolutionStatementBodyDTO {\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    unresolved: ").append(this.toIndentedString(this.unresolved)).append("\n");
        sb.append("    resolutionEntries: ").append(this.toIndentedString(this.resolutionEntries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

