/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.AliasActionEnum;
import io.nem.sdk.openapi.okhttp_gson.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to link a namespace to an account.")
public class AddressAliasTransactionDTO {
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @SerializedName(value="signerPublicKey")
    private String signerPublicKey;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private NetworkTypeEnum network;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_MAX_FEE = "maxFee";
    @SerializedName(value="maxFee")
    private BigInteger maxFee = null;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private BigInteger deadline = null;
    public static final String SERIALIZED_NAME_NAMESPACE_ID = "namespaceId";
    @SerializedName(value="namespaceId")
    private String namespaceId;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_ALIAS_ACTION = "aliasAction";
    @SerializedName(value="aliasAction")
    private AliasActionEnum aliasAction;

    public AddressAliasTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AddressAliasTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public AddressAliasTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AddressAliasTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public AddressAliasTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AddressAliasTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public AddressAliasTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public AddressAliasTransactionDTO namespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Namespace identifier.")
    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public AddressAliasTransactionDTO address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Decoded address.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AddressAliasTransactionDTO aliasAction(AliasActionEnum aliasAction) {
        this.aliasAction = aliasAction;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AliasActionEnum getAliasAction() {
        return this.aliasAction;
    }

    public void setAliasAction(AliasActionEnum aliasAction) {
        this.aliasAction = aliasAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressAliasTransactionDTO addressAliasTransactionDTO = (AddressAliasTransactionDTO)o;
        return Objects.equals(this.signature, addressAliasTransactionDTO.signature) && Objects.equals(this.signerPublicKey, addressAliasTransactionDTO.signerPublicKey) && Objects.equals(this.version, addressAliasTransactionDTO.version) && Objects.equals((Object)this.network, (Object)addressAliasTransactionDTO.network) && Objects.equals(this.type, addressAliasTransactionDTO.type) && Objects.equals(this.maxFee, addressAliasTransactionDTO.maxFee) && Objects.equals(this.deadline, addressAliasTransactionDTO.deadline) && Objects.equals(this.namespaceId, addressAliasTransactionDTO.namespaceId) && Objects.equals(this.address, addressAliasTransactionDTO.address) && Objects.equals((Object)this.aliasAction, (Object)addressAliasTransactionDTO.aliasAction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.namespaceId, this.address, this.aliasAction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressAliasTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    namespaceId: ").append(this.toIndentedString(this.namespaceId)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    aliasAction: ").append(this.toIndentedString((Object)this.aliasAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

