/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionFlagsEnum;
import io.nem.sdk.openapi.okhttp_gson.model.NetworkTypeEnum;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Transaction to prevent outgoing transactions by transaction type.")
public class AccountOperationRestrictionTransactionDTO {
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @SerializedName(value="signerPublicKey")
    private String signerPublicKey;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private NetworkTypeEnum network;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_MAX_FEE = "maxFee";
    @SerializedName(value="maxFee")
    private BigInteger maxFee = null;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private BigInteger deadline = null;
    public static final String SERIALIZED_NAME_RESTRICTION_FLAGS = "restrictionFlags";
    @SerializedName(value="restrictionFlags")
    private AccountRestrictionFlagsEnum restrictionFlags;
    public static final String SERIALIZED_NAME_RESTRICTION_ADDITIONS = "restrictionAdditions";
    @SerializedName(value="restrictionAdditions")
    private List<TransactionTypeEnum> restrictionAdditions = new ArrayList<TransactionTypeEnum>();
    public static final String SERIALIZED_NAME_RESTRICTION_DELETIONS = "restrictionDeletions";
    @SerializedName(value="restrictionDeletions")
    private List<TransactionTypeEnum> restrictionDeletions = new ArrayList<TransactionTypeEnum>();

    public AccountOperationRestrictionTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AccountOperationRestrictionTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public AccountOperationRestrictionTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AccountOperationRestrictionTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public AccountOperationRestrictionTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AccountOperationRestrictionTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public AccountOperationRestrictionTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public AccountOperationRestrictionTransactionDTO restrictionFlags(AccountRestrictionFlagsEnum restrictionFlags) {
        this.restrictionFlags = restrictionFlags;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountRestrictionFlagsEnum getRestrictionFlags() {
        return this.restrictionFlags;
    }

    public void setRestrictionFlags(AccountRestrictionFlagsEnum restrictionFlags) {
        this.restrictionFlags = restrictionFlags;
    }

    public AccountOperationRestrictionTransactionDTO restrictionAdditions(List<TransactionTypeEnum> restrictionAdditions) {
        this.restrictionAdditions = restrictionAdditions;
        return this;
    }

    public AccountOperationRestrictionTransactionDTO addRestrictionAdditionsItem(TransactionTypeEnum restrictionAdditionsItem) {
        this.restrictionAdditions.add(restrictionAdditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Account restriction additions.")
    public List<TransactionTypeEnum> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public void setRestrictionAdditions(List<TransactionTypeEnum> restrictionAdditions) {
        this.restrictionAdditions = restrictionAdditions;
    }

    public AccountOperationRestrictionTransactionDTO restrictionDeletions(List<TransactionTypeEnum> restrictionDeletions) {
        this.restrictionDeletions = restrictionDeletions;
        return this;
    }

    public AccountOperationRestrictionTransactionDTO addRestrictionDeletionsItem(TransactionTypeEnum restrictionDeletionsItem) {
        this.restrictionDeletions.add(restrictionDeletionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Account restriction deletions.")
    public List<TransactionTypeEnum> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }

    public void setRestrictionDeletions(List<TransactionTypeEnum> restrictionDeletions) {
        this.restrictionDeletions = restrictionDeletions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountOperationRestrictionTransactionDTO accountOperationRestrictionTransactionDTO = (AccountOperationRestrictionTransactionDTO)o;
        return Objects.equals(this.signature, accountOperationRestrictionTransactionDTO.signature) && Objects.equals(this.signerPublicKey, accountOperationRestrictionTransactionDTO.signerPublicKey) && Objects.equals(this.version, accountOperationRestrictionTransactionDTO.version) && Objects.equals((Object)this.network, (Object)accountOperationRestrictionTransactionDTO.network) && Objects.equals(this.type, accountOperationRestrictionTransactionDTO.type) && Objects.equals(this.maxFee, accountOperationRestrictionTransactionDTO.maxFee) && Objects.equals(this.deadline, accountOperationRestrictionTransactionDTO.deadline) && Objects.equals((Object)this.restrictionFlags, (Object)accountOperationRestrictionTransactionDTO.restrictionFlags) && Objects.equals(this.restrictionAdditions, accountOperationRestrictionTransactionDTO.restrictionAdditions) && Objects.equals(this.restrictionDeletions, accountOperationRestrictionTransactionDTO.restrictionDeletions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.restrictionFlags, this.restrictionAdditions, this.restrictionDeletions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountOperationRestrictionTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    restrictionFlags: ").append(this.toIndentedString((Object)this.restrictionFlags)).append("\n");
        sb.append("    restrictionAdditions: ").append(this.toIndentedString(this.restrictionAdditions)).append("\n");
        sb.append("    restrictionDeletions: ").append(this.toIndentedString(this.restrictionDeletions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

