/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.8
 *
 * The version of the OpenAPI document: 0.7.22
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.AnnounceTransactionInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.Cosignature;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionHashes;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionIds;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionPayload;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionStatusDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionRoutesApi {
    private ApiClient localVarApiClient;

    public TransactionRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for announceCosignatureTransaction
     * @param cosignature  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call announceCosignatureTransactionCall(Cosignature cosignature, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = cosignature;

        // create path and map variables
        String localVarPath = "/transaction/cosignature";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call announceCosignatureTransactionValidateBeforeCall(Cosignature cosignature, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'cosignature' is set
        if (cosignature == null) {
            throw new ApiException("Missing the required parameter 'cosignature' when calling announceCosignatureTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = announceCosignatureTransactionCall(cosignature, _callback);
        return localVarCall;

    }

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @return AnnounceTransactionInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AnnounceTransactionInfoDTO announceCosignatureTransaction(Cosignature cosignature) throws ApiException {
        ApiResponse<AnnounceTransactionInfoDTO> localVarResp = announceCosignatureTransactionWithHttpInfo(cosignature);
        return localVarResp.getData();
    }

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AnnounceTransactionInfoDTO> announceCosignatureTransactionWithHttpInfo(Cosignature cosignature) throws ApiException {
        okhttp3.Call localVarCall = announceCosignatureTransactionValidateBeforeCall(cosignature, null);
        Type localVarReturnType = new TypeToken<AnnounceTransactionInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Announce a cosignature transaction (asynchronously)
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call announceCosignatureTransactionAsync(Cosignature cosignature, final ApiCallback<AnnounceTransactionInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = announceCosignatureTransactionValidateBeforeCall(cosignature, _callback);
        Type localVarReturnType = new TypeToken<AnnounceTransactionInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for announcePartialTransaction
     * @param transactionPayload  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call announcePartialTransactionCall(TransactionPayload transactionPayload, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transactionPayload;

        // create path and map variables
        String localVarPath = "/transaction/partial";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call announcePartialTransactionValidateBeforeCall(TransactionPayload transactionPayload, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionPayload' is set
        if (transactionPayload == null) {
            throw new ApiException("Missing the required parameter 'transactionPayload' when calling announcePartialTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = announcePartialTransactionCall(transactionPayload, _callback);
        return localVarCall;

    }

    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @return AnnounceTransactionInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AnnounceTransactionInfoDTO announcePartialTransaction(TransactionPayload transactionPayload) throws ApiException {
        ApiResponse<AnnounceTransactionInfoDTO> localVarResp = announcePartialTransactionWithHttpInfo(transactionPayload);
        return localVarResp.getData();
    }

    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AnnounceTransactionInfoDTO> announcePartialTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
        okhttp3.Call localVarCall = announcePartialTransactionValidateBeforeCall(transactionPayload, null);
        Type localVarReturnType = new TypeToken<AnnounceTransactionInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Announce an aggregate bonded transaction (asynchronously)
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call announcePartialTransactionAsync(TransactionPayload transactionPayload, final ApiCallback<AnnounceTransactionInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = announcePartialTransactionValidateBeforeCall(transactionPayload, _callback);
        Type localVarReturnType = new TypeToken<AnnounceTransactionInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for announceTransaction
     * @param transactionPayload  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call announceTransactionCall(TransactionPayload transactionPayload, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transactionPayload;

        // create path and map variables
        String localVarPath = "/transaction";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call announceTransactionValidateBeforeCall(TransactionPayload transactionPayload, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionPayload' is set
        if (transactionPayload == null) {
            throw new ApiException("Missing the required parameter 'transactionPayload' when calling announceTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = announceTransactionCall(transactionPayload, _callback);
        return localVarCall;

    }

    /**
     * Announce a new transaction
     * Announces a transaction to the network. We recommended to use the NEM2-SDK to announce transactions as they should be serialized. 
     * @param transactionPayload  (required)
     * @return AnnounceTransactionInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AnnounceTransactionInfoDTO announceTransaction(TransactionPayload transactionPayload) throws ApiException {
        ApiResponse<AnnounceTransactionInfoDTO> localVarResp = announceTransactionWithHttpInfo(transactionPayload);
        return localVarResp.getData();
    }

    /**
     * Announce a new transaction
     * Announces a transaction to the network. We recommended to use the NEM2-SDK to announce transactions as they should be serialized. 
     * @param transactionPayload  (required)
     * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AnnounceTransactionInfoDTO> announceTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
        okhttp3.Call localVarCall = announceTransactionValidateBeforeCall(transactionPayload, null);
        Type localVarReturnType = new TypeToken<AnnounceTransactionInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Announce a new transaction (asynchronously)
     * Announces a transaction to the network. We recommended to use the NEM2-SDK to announce transactions as they should be serialized. 
     * @param transactionPayload  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call announceTransactionAsync(TransactionPayload transactionPayload, final ApiCallback<AnnounceTransactionInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = announceTransactionValidateBeforeCall(transactionPayload, _callback);
        Type localVarReturnType = new TypeToken<AnnounceTransactionInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTransaction
     * @param transactionId Transaction identifier or hash. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionCall(String transactionId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/transaction/{transactionId}"
            .replaceAll("\\{" + "transactionId" + "\\}", localVarApiClient.escapeString(transactionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTransactionValidateBeforeCall(String transactionId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionId' is set
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling getTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = getTransactionCall(transactionId, _callback);
        return localVarCall;

    }

    /**
     * Get transaction information
     * Returns transaction information given a transactionId or hash.
     * @param transactionId Transaction identifier or hash. (required)
     * @return TransactionInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public TransactionInfoDTO getTransaction(String transactionId) throws ApiException {
        ApiResponse<TransactionInfoDTO> localVarResp = getTransactionWithHttpInfo(transactionId);
        return localVarResp.getData();
    }

    /**
     * Get transaction information
     * Returns transaction information given a transactionId or hash.
     * @param transactionId Transaction identifier or hash. (required)
     * @return ApiResponse&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionInfoDTO> getTransactionWithHttpInfo(String transactionId) throws ApiException {
        okhttp3.Call localVarCall = getTransactionValidateBeforeCall(transactionId, null);
        Type localVarReturnType = new TypeToken<TransactionInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get transaction information (asynchronously)
     * Returns transaction information given a transactionId or hash.
     * @param transactionId Transaction identifier or hash. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionAsync(String transactionId, final ApiCallback<TransactionInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTransactionValidateBeforeCall(transactionId, _callback);
        Type localVarReturnType = new TypeToken<TransactionInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTransactionStatus
     * @param hash Transaction hash. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionStatusCall(String hash, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/transaction/{hash}/status"
            .replaceAll("\\{" + "hash" + "\\}", localVarApiClient.escapeString(hash.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTransactionStatusValidateBeforeCall(String hash, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            throw new ApiException("Missing the required parameter 'hash' when calling getTransactionStatus(Async)");
        }
        

        okhttp3.Call localVarCall = getTransactionStatusCall(hash, _callback);
        return localVarCall;

    }

    /**
     * Get transaction status
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @return TransactionStatusDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public TransactionStatusDTO getTransactionStatus(String hash) throws ApiException {
        ApiResponse<TransactionStatusDTO> localVarResp = getTransactionStatusWithHttpInfo(hash);
        return localVarResp.getData();
    }

    /**
     * Get transaction status
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @return ApiResponse&lt;TransactionStatusDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TransactionStatusDTO> getTransactionStatusWithHttpInfo(String hash) throws ApiException {
        okhttp3.Call localVarCall = getTransactionStatusValidateBeforeCall(hash, null);
        Type localVarReturnType = new TypeToken<TransactionStatusDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get transaction status (asynchronously)
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionStatusAsync(String hash, final ApiCallback<TransactionStatusDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTransactionStatusValidateBeforeCall(hash, _callback);
        Type localVarReturnType = new TypeToken<TransactionStatusDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTransactions
     * @param transactionIds  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionsCall(TransactionIds transactionIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transactionIds;

        // create path and map variables
        String localVarPath = "/transaction";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTransactionsValidateBeforeCall(TransactionIds transactionIds, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionIds' is set
        if (transactionIds == null) {
            throw new ApiException("Missing the required parameter 'transactionIds' when calling getTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = getTransactionsCall(transactionIds, _callback);
        return localVarCall;

    }

    /**
     * Get transactions information
     * Returns transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> getTransactions(TransactionIds transactionIds) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = getTransactionsWithHttpInfo(transactionIds);
        return localVarResp.getData();
    }

    /**
     * Get transactions information
     * Returns transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> getTransactionsWithHttpInfo(TransactionIds transactionIds) throws ApiException {
        okhttp3.Call localVarCall = getTransactionsValidateBeforeCall(transactionIds, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get transactions information (asynchronously)
     * Returns transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionsAsync(TransactionIds transactionIds, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTransactionsValidateBeforeCall(transactionIds, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTransactionsStatuses
     * @param transactionHashes  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionsStatusesCall(TransactionHashes transactionHashes, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transactionHashes;

        // create path and map variables
        String localVarPath = "/transaction/statuses";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTransactionsStatusesValidateBeforeCall(TransactionHashes transactionHashes, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'transactionHashes' is set
        if (transactionHashes == null) {
            throw new ApiException("Missing the required parameter 'transactionHashes' when calling getTransactionsStatuses(Async)");
        }
        

        okhttp3.Call localVarCall = getTransactionsStatusesCall(transactionHashes, _callback);
        return localVarCall;

    }

    /**
     * Get transactions status
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @return List&lt;TransactionStatusDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionStatusDTO> getTransactionsStatuses(TransactionHashes transactionHashes) throws ApiException {
        ApiResponse<List<TransactionStatusDTO>> localVarResp = getTransactionsStatusesWithHttpInfo(transactionHashes);
        return localVarResp.getData();
    }

    /**
     * Get transactions status
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @return ApiResponse&lt;List&lt;TransactionStatusDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionStatusDTO>> getTransactionsStatusesWithHttpInfo(TransactionHashes transactionHashes) throws ApiException {
        okhttp3.Call localVarCall = getTransactionsStatusesValidateBeforeCall(transactionHashes, null);
        Type localVarReturnType = new TypeToken<List<TransactionStatusDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get transactions status (asynchronously)
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTransactionsStatusesAsync(TransactionHashes transactionHashes, final ApiCallback<List<TransactionStatusDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTransactionsStatusesValidateBeforeCall(transactionHashes, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionStatusDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
