/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.8
 *
 * The version of the OpenAPI document: 0.7.22
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionsInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestrictionAccountRoutesApi {
    private ApiClient localVarApiClient;

    public RestrictionAccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RestrictionAccountRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAccountRestrictions
     * @param accountId Account public key or address. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountRestrictionsCall(String accountId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/restrictions/account/{accountId}"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountRestrictionsValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountRestrictions(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountRestrictionsCall(accountId, _callback);
        return localVarCall;

    }

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address. (required)
     * @return AccountRestrictionsInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AccountRestrictionsInfoDTO getAccountRestrictions(String accountId) throws ApiException {
        ApiResponse<AccountRestrictionsInfoDTO> localVarResp = getAccountRestrictionsWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address. (required)
     * @return ApiResponse&lt;AccountRestrictionsInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountRestrictionsInfoDTO> getAccountRestrictionsWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getAccountRestrictionsValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<AccountRestrictionsInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the account restrictions (asynchronously)
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountRestrictionsAsync(String accountId, final ApiCallback<AccountRestrictionsInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountRestrictionsValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<AccountRestrictionsInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountRestrictionsFromAccounts
     * @param accountIds  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountRestrictionsFromAccountsCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountIds;

        // create path and map variables
        String localVarPath = "/restrictions/account";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountRestrictionsFromAccountsValidateBeforeCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAccountRestrictionsFromAccountsCall(accountIds, _callback);
        return localVarCall;

    }

    /**
     * Get account restrictions for given array of addresses
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @return List&lt;AccountRestrictionsInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<AccountRestrictionsInfoDTO> getAccountRestrictionsFromAccounts(AccountIds accountIds) throws ApiException {
        ApiResponse<List<AccountRestrictionsInfoDTO>> localVarResp = getAccountRestrictionsFromAccountsWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    /**
     * Get account restrictions for given array of addresses
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @return ApiResponse&lt;List&lt;AccountRestrictionsInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<AccountRestrictionsInfoDTO>> getAccountRestrictionsFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
        okhttp3.Call localVarCall = getAccountRestrictionsFromAccountsValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<List<AccountRestrictionsInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get account restrictions for given array of addresses (asynchronously)
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountRestrictionsFromAccountsAsync(AccountIds accountIds, final ApiCallback<List<AccountRestrictionsInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountRestrictionsFromAccountsValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<List<AccountRestrictionsInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
