/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.api;

import com.google.gson.reflect.TypeToken;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.StatementsDTO;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ReceiptRoutesApi {
    private ApiClient localVarApiClient;

    public ReceiptRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReceiptRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getBlockReceiptsCall(BigInteger height, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/block/{height}/receipts".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBlockReceiptsValidateBeforeCall(BigInteger height, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockReceipts(Async)");
        }
        Call localVarCall = this.getBlockReceiptsCall(height, _callback);
        return localVarCall;
    }

    public StatementsDTO getBlockReceipts(BigInteger height) throws ApiException {
        ApiResponse<StatementsDTO> localVarResp = this.getBlockReceiptsWithHttpInfo(height);
        return localVarResp.getData();
    }

    public ApiResponse<StatementsDTO> getBlockReceiptsWithHttpInfo(BigInteger height) throws ApiException {
        Call localVarCall = this.getBlockReceiptsValidateBeforeCall(height, null);
        Type localVarReturnType = new TypeToken<StatementsDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBlockReceiptsAsync(BigInteger height, ApiCallback<StatementsDTO> _callback) throws ApiException {
        Call localVarCall = this.getBlockReceiptsValidateBeforeCall(height, _callback);
        Type localVarReturnType = new TypeToken<StatementsDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMerkleReceiptsCall(BigInteger height, String hash, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/block/{height}/receipt/{hash}/merkle".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString())).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMerkleReceiptsValidateBeforeCall(BigInteger height, String hash, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getMerkleReceipts(Async)");
        }
        if (hash == null) {
            throw new ApiException("Missing the required parameter 'hash' when calling getMerkleReceipts(Async)");
        }
        Call localVarCall = this.getMerkleReceiptsCall(height, hash, _callback);
        return localVarCall;
    }

    public MerkleProofInfoDTO getMerkleReceipts(BigInteger height, String hash) throws ApiException {
        ApiResponse<MerkleProofInfoDTO> localVarResp = this.getMerkleReceiptsWithHttpInfo(height, hash);
        return localVarResp.getData();
    }

    public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(BigInteger height, String hash) throws ApiException {
        Call localVarCall = this.getMerkleReceiptsValidateBeforeCall(height, hash, null);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMerkleReceiptsAsync(BigInteger height, String hash, ApiCallback<MerkleProofInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getMerkleReceiptsValidateBeforeCall(height, hash, _callback);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

