/*
 * Catapult REST Endpoints
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.7.20.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountsNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicIds;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicsNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceIds;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceNameDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespacesInfoDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamespaceRoutesApi {
    private ApiClient localVarApiClient;

    public NamespaceRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NamespaceRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAccountsNames
     * @param accountIds  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsNamesCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountIds;

        // create path and map variables
        String localVarPath = "/account/names";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountsNamesValidateBeforeCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAccountsNamesCall(accountIds, _callback);
        return localVarCall;

    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @return AccountsNamesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AccountsNamesDTO getAccountsNames(AccountIds accountIds) throws ApiException {
        ApiResponse<AccountsNamesDTO> localVarResp = getAccountsNamesWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @return ApiResponse&lt;AccountsNamesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsNamesDTO> getAccountsNamesWithHttpInfo(AccountIds accountIds) throws ApiException {
        okhttp3.Call localVarCall = getAccountsNamesValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<AccountsNamesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get readable names for a set of accountIds (asynchronously)
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsNamesAsync(AccountIds accountIds, final ApiCallback<AccountsNamesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountsNamesValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<AccountsNamesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMosaicsNames
     * @param mosaicIds  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicsNamesCall(MosaicIds mosaicIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = mosaicIds;

        // create path and map variables
        String localVarPath = "/mosaic/names";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMosaicsNamesValidateBeforeCall(MosaicIds mosaicIds, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'mosaicIds' is set
        if (mosaicIds == null) {
            throw new ApiException("Missing the required parameter 'mosaicIds' when calling getMosaicsNames(Async)");
        }
        

        okhttp3.Call localVarCall = getMosaicsNamesCall(mosaicIds, _callback);
        return localVarCall;

    }

    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @return MosaicsNamesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MosaicsNamesDTO getMosaicsNames(MosaicIds mosaicIds) throws ApiException {
        ApiResponse<MosaicsNamesDTO> localVarResp = getMosaicsNamesWithHttpInfo(mosaicIds);
        return localVarResp.getData();
    }

    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @return ApiResponse&lt;MosaicsNamesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MosaicsNamesDTO> getMosaicsNamesWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        okhttp3.Call localVarCall = getMosaicsNamesValidateBeforeCall(mosaicIds, null);
        Type localVarReturnType = new TypeToken<MosaicsNamesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get readable names for a set of mosaics (asynchronously)
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMosaicsNamesAsync(MosaicIds mosaicIds, final ApiCallback<MosaicsNamesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMosaicsNamesValidateBeforeCall(mosaicIds, _callback);
        Type localVarReturnType = new TypeToken<MosaicsNamesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNamespace
     * @param namespaceId Namespace identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceCall(String namespaceId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/namespace/{namespaceId}"
            .replaceAll("\\{" + "namespaceId" + "\\}", localVarApiClient.escapeString(namespaceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNamespaceValidateBeforeCall(String namespaceId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespace(Async)");
        }
        

        okhttp3.Call localVarCall = getNamespaceCall(namespaceId, _callback);
        return localVarCall;

    }

    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @return NamespaceInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public NamespaceInfoDTO getNamespace(String namespaceId) throws ApiException {
        ApiResponse<NamespaceInfoDTO> localVarResp = getNamespaceWithHttpInfo(namespaceId);
        return localVarResp.getData();
    }

    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @return ApiResponse&lt;NamespaceInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NamespaceInfoDTO> getNamespaceWithHttpInfo(String namespaceId) throws ApiException {
        okhttp3.Call localVarCall = getNamespaceValidateBeforeCall(namespaceId, null);
        Type localVarReturnType = new TypeToken<NamespaceInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get namespace information (asynchronously)
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespaceAsync(String namespaceId, final ApiCallback<NamespaceInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNamespaceValidateBeforeCall(namespaceId, _callback);
        Type localVarReturnType = new TypeToken<NamespaceInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNamespacesFromAccount
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Namespace identifier up to which transactions are returned. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespacesFromAccountCall(String accountId, Integer pageSize, String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/namespaces"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNamespacesFromAccountValidateBeforeCall(String accountId, Integer pageSize, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getNamespacesFromAccount(Async)");
        }
        

        okhttp3.Call localVarCall = getNamespacesFromAccountCall(accountId, pageSize, id, _callback);
        return localVarCall;

    }

    /**
     * Get namespaces created by an account
     * Gets an array of namespaces for a given account address.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Namespace identifier up to which transactions are returned. (optional)
     * @return NamespacesInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public NamespacesInfoDTO getNamespacesFromAccount(String accountId, Integer pageSize, String id) throws ApiException {
        ApiResponse<NamespacesInfoDTO> localVarResp = getNamespacesFromAccountWithHttpInfo(accountId, pageSize, id);
        return localVarResp.getData();
    }

    /**
     * Get namespaces created by an account
     * Gets an array of namespaces for a given account address.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Namespace identifier up to which transactions are returned. (optional)
     * @return ApiResponse&lt;NamespacesInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NamespacesInfoDTO> getNamespacesFromAccountWithHttpInfo(String accountId, Integer pageSize, String id) throws ApiException {
        okhttp3.Call localVarCall = getNamespacesFromAccountValidateBeforeCall(accountId, pageSize, id, null);
        Type localVarReturnType = new TypeToken<NamespacesInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get namespaces created by an account (asynchronously)
     * Gets an array of namespaces for a given account address.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Namespace identifier up to which transactions are returned. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespacesFromAccountAsync(String accountId, Integer pageSize, String id, final ApiCallback<NamespacesInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNamespacesFromAccountValidateBeforeCall(accountId, pageSize, id, _callback);
        Type localVarReturnType = new TypeToken<NamespacesInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNamespacesFromAccounts
     * @param accountIds  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespacesFromAccountsCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountIds;

        // create path and map variables
        String localVarPath = "/account/namespaces";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNamespacesFromAccountsValidateBeforeCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getNamespacesFromAccountsCall(accountIds, _callback);
        return localVarCall;

    }

    /**
     * Get namespaces for given array of addresses
     * Gets namespaces for a given array of addresses.
     * @param accountIds  (optional)
     * @return NamespacesInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public NamespacesInfoDTO getNamespacesFromAccounts(AccountIds accountIds) throws ApiException {
        ApiResponse<NamespacesInfoDTO> localVarResp = getNamespacesFromAccountsWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    /**
     * Get namespaces for given array of addresses
     * Gets namespaces for a given array of addresses.
     * @param accountIds  (optional)
     * @return ApiResponse&lt;NamespacesInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NamespacesInfoDTO> getNamespacesFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
        okhttp3.Call localVarCall = getNamespacesFromAccountsValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<NamespacesInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get namespaces for given array of addresses (asynchronously)
     * Gets namespaces for a given array of addresses.
     * @param accountIds  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespacesFromAccountsAsync(AccountIds accountIds, final ApiCallback<NamespacesInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNamespacesFromAccountsValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<NamespacesInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNamespacesNames
     * @param namespaceIds  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespacesNamesCall(NamespaceIds namespaceIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = namespaceIds;

        // create path and map variables
        String localVarPath = "/namespace/names";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNamespacesNamesValidateBeforeCall(NamespaceIds namespaceIds, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespaceIds' is set
        if (namespaceIds == null) {
            throw new ApiException("Missing the required parameter 'namespaceIds' when calling getNamespacesNames(Async)");
        }
        

        okhttp3.Call localVarCall = getNamespacesNamesCall(namespaceIds, _callback);
        return localVarCall;

    }

    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @return List&lt;NamespaceNameDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<NamespaceNameDTO> getNamespacesNames(NamespaceIds namespaceIds) throws ApiException {
        ApiResponse<List<NamespaceNameDTO>> localVarResp = getNamespacesNamesWithHttpInfo(namespaceIds);
        return localVarResp.getData();
    }

    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @return ApiResponse&lt;List&lt;NamespaceNameDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<NamespaceNameDTO>> getNamespacesNamesWithHttpInfo(NamespaceIds namespaceIds) throws ApiException {
        okhttp3.Call localVarCall = getNamespacesNamesValidateBeforeCall(namespaceIds, null);
        Type localVarReturnType = new TypeToken<List<NamespaceNameDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get readable names for a set of namespaces (asynchronously)
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNamespacesNamesAsync(NamespaceIds namespaceIds, final ApiCallback<List<NamespaceNameDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNamespacesNamesValidateBeforeCall(namespaceIds, _callback);
        Type localVarReturnType = new TypeToken<List<NamespaceNameDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
