/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.MessageDTO;
import io.nem.sdk.openapi.okhttp_gson.model.Mosaic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Transaction to transfer mosaics and a message to another account.")
public class TransferTransactionDTO {
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @SerializedName(value="signerPublicKey")
    private String signerPublicKey;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_MAX_FEE = "maxFee";
    @SerializedName(value="maxFee")
    private BigInteger maxFee = null;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private BigInteger deadline = null;
    public static final String SERIALIZED_NAME_RECIPIENT_ADDRESS = "recipientAddress";
    @SerializedName(value="recipientAddress")
    private String recipientAddress;
    public static final String SERIALIZED_NAME_MOSAICS = "mosaics";
    @SerializedName(value="mosaics")
    private List<Mosaic> mosaics = new ArrayList<Mosaic>();
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private MessageDTO message = null;

    public TransferTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public TransferTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public TransferTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="36867", required=true, value="Entity version. The higher byte represents the network identifier: * 0x68 (MAIN_NET) - Public main network. * 0x98 (TEST_NET) - Public test network. * 0x60 (MIJIN) - Private network. * 0x90 (MIJIN_TEST) - Private test network. ")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public TransferTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public TransferTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public TransferTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public TransferTransactionDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Address decoded. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public TransferTransactionDTO mosaics(List<Mosaic> mosaics) {
        this.mosaics = mosaics;
        return this;
    }

    public TransferTransactionDTO addMosaicsItem(Mosaic mosaicsItem) {
        this.mosaics.add(mosaicsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of mosaics sent to the recipient. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of a instead of a mosaicId corresponds to a mosaicId.")
    public List<Mosaic> getMosaics() {
        return this.mosaics;
    }

    public void setMosaics(List<Mosaic> mosaics) {
        this.mosaics = mosaics;
    }

    public TransferTransactionDTO message(MessageDTO message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MessageDTO getMessage() {
        return this.message;
    }

    public void setMessage(MessageDTO message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferTransactionDTO transferTransactionDTO = (TransferTransactionDTO)o;
        return Objects.equals(this.signature, transferTransactionDTO.signature) && Objects.equals(this.signerPublicKey, transferTransactionDTO.signerPublicKey) && Objects.equals(this.version, transferTransactionDTO.version) && Objects.equals(this.type, transferTransactionDTO.type) && Objects.equals(this.maxFee, transferTransactionDTO.maxFee) && Objects.equals(this.deadline, transferTransactionDTO.deadline) && Objects.equals(this.recipientAddress, transferTransactionDTO.recipientAddress) && Objects.equals(this.mosaics, transferTransactionDTO.mosaics) && Objects.equals(this.message, transferTransactionDTO.message);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.signerPublicKey, this.version, this.type, this.maxFee, this.deadline, this.recipientAddress, this.mosaics, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    mosaics: ").append(this.toIndentedString(this.mosaics)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

