/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicRestrictionTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to set a network-wide restriction rule to a mosaic.")
public class MosaicGlobalRestrictionTransactionDTO {
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @SerializedName(value="signerPublicKey")
    private String signerPublicKey;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_MAX_FEE = "maxFee";
    @SerializedName(value="maxFee")
    private BigInteger maxFee = null;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private BigInteger deadline = null;
    public static final String SERIALIZED_NAME_MOSAIC_ID = "mosaicId";
    @SerializedName(value="mosaicId")
    private String mosaicId;
    public static final String SERIALIZED_NAME_REFERENCE_MOSAIC_ID = "referenceMosaicId";
    @SerializedName(value="referenceMosaicId")
    private String referenceMosaicId;
    public static final String SERIALIZED_NAME_RESTRICTION_KEY = "restrictionKey";
    @SerializedName(value="restrictionKey")
    private String restrictionKey;
    public static final String SERIALIZED_NAME_PREVIOUS_RESTRICTION_VALUE = "previousRestrictionValue";
    @SerializedName(value="previousRestrictionValue")
    private BigInteger previousRestrictionValue = null;
    public static final String SERIALIZED_NAME_PREVIOUS_RESTRICTION_TYPE = "previousRestrictionType";
    @SerializedName(value="previousRestrictionType")
    private MosaicRestrictionTypeEnum previousRestrictionType;
    public static final String SERIALIZED_NAME_NEW_RESTRICTION_VALUE = "newRestrictionValue";
    @SerializedName(value="newRestrictionValue")
    private BigInteger newRestrictionValue = null;
    public static final String SERIALIZED_NAME_NEW_RESTRICTION_TYPE = "newRestrictionType";
    @SerializedName(value="newRestrictionType")
    private MosaicRestrictionTypeEnum newRestrictionType;

    public MosaicGlobalRestrictionTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public MosaicGlobalRestrictionTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public MosaicGlobalRestrictionTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="36867", required=true, value="Entity version. The higher byte represents the network identifier: * 0x68 (MAIN_NET) - Public main network. * 0x98 (TEST_NET) - Public test network. * 0x60 (MIJIN) - Private network. * 0x90 (MIJIN_TEST) - Private test network. ")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MosaicGlobalRestrictionTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public MosaicGlobalRestrictionTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public MosaicGlobalRestrictionTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public MosaicGlobalRestrictionTransactionDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real  mosaic identifier. ")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public MosaicGlobalRestrictionTransactionDTO referenceMosaicId(String referenceMosaicId) {
        this.referenceMosaicId = referenceMosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real  mosaic identifier. ")
    public String getReferenceMosaicId() {
        return this.referenceMosaicId;
    }

    public void setReferenceMosaicId(String referenceMosaicId) {
        this.referenceMosaicId = referenceMosaicId;
    }

    public MosaicGlobalRestrictionTransactionDTO restrictionKey(String restrictionKey) {
        this.restrictionKey = restrictionKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Restriction key.")
    public String getRestrictionKey() {
        return this.restrictionKey;
    }

    public void setRestrictionKey(String restrictionKey) {
        this.restrictionKey = restrictionKey;
    }

    public MosaicGlobalRestrictionTransactionDTO previousRestrictionValue(BigInteger previousRestrictionValue) {
        this.previousRestrictionValue = previousRestrictionValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Previous restriction value.")
    public BigInteger getPreviousRestrictionValue() {
        return this.previousRestrictionValue;
    }

    public void setPreviousRestrictionValue(BigInteger previousRestrictionValue) {
        this.previousRestrictionValue = previousRestrictionValue;
    }

    public MosaicGlobalRestrictionTransactionDTO previousRestrictionType(MosaicRestrictionTypeEnum previousRestrictionType) {
        this.previousRestrictionType = previousRestrictionType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MosaicRestrictionTypeEnum getPreviousRestrictionType() {
        return this.previousRestrictionType;
    }

    public void setPreviousRestrictionType(MosaicRestrictionTypeEnum previousRestrictionType) {
        this.previousRestrictionType = previousRestrictionType;
    }

    public MosaicGlobalRestrictionTransactionDTO newRestrictionValue(BigInteger newRestrictionValue) {
        this.newRestrictionValue = newRestrictionValue;
        return this;
    }

    @ApiModelProperty(required=true, value="New restriction value.")
    public BigInteger getNewRestrictionValue() {
        return this.newRestrictionValue;
    }

    public void setNewRestrictionValue(BigInteger newRestrictionValue) {
        this.newRestrictionValue = newRestrictionValue;
    }

    public MosaicGlobalRestrictionTransactionDTO newRestrictionType(MosaicRestrictionTypeEnum newRestrictionType) {
        this.newRestrictionType = newRestrictionType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MosaicRestrictionTypeEnum getNewRestrictionType() {
        return this.newRestrictionType;
    }

    public void setNewRestrictionType(MosaicRestrictionTypeEnum newRestrictionType) {
        this.newRestrictionType = newRestrictionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicGlobalRestrictionTransactionDTO mosaicGlobalRestrictionTransactionDTO = (MosaicGlobalRestrictionTransactionDTO)o;
        return Objects.equals(this.signature, mosaicGlobalRestrictionTransactionDTO.signature) && Objects.equals(this.signerPublicKey, mosaicGlobalRestrictionTransactionDTO.signerPublicKey) && Objects.equals(this.version, mosaicGlobalRestrictionTransactionDTO.version) && Objects.equals(this.type, mosaicGlobalRestrictionTransactionDTO.type) && Objects.equals(this.maxFee, mosaicGlobalRestrictionTransactionDTO.maxFee) && Objects.equals(this.deadline, mosaicGlobalRestrictionTransactionDTO.deadline) && Objects.equals(this.mosaicId, mosaicGlobalRestrictionTransactionDTO.mosaicId) && Objects.equals(this.referenceMosaicId, mosaicGlobalRestrictionTransactionDTO.referenceMosaicId) && Objects.equals(this.restrictionKey, mosaicGlobalRestrictionTransactionDTO.restrictionKey) && Objects.equals(this.previousRestrictionValue, mosaicGlobalRestrictionTransactionDTO.previousRestrictionValue) && Objects.equals((Object)this.previousRestrictionType, (Object)mosaicGlobalRestrictionTransactionDTO.previousRestrictionType) && Objects.equals(this.newRestrictionValue, mosaicGlobalRestrictionTransactionDTO.newRestrictionValue) && Objects.equals((Object)this.newRestrictionType, (Object)mosaicGlobalRestrictionTransactionDTO.newRestrictionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.type, this.maxFee, this.deadline, this.mosaicId, this.referenceMosaicId, this.restrictionKey, this.previousRestrictionValue, this.previousRestrictionType, this.newRestrictionValue, this.newRestrictionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicGlobalRestrictionTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    referenceMosaicId: ").append(this.toIndentedString(this.referenceMosaicId)).append("\n");
        sb.append("    restrictionKey: ").append(this.toIndentedString(this.restrictionKey)).append("\n");
        sb.append("    previousRestrictionValue: ").append(this.toIndentedString(this.previousRestrictionValue)).append("\n");
        sb.append("    previousRestrictionType: ").append(this.toIndentedString((Object)this.previousRestrictionType)).append("\n");
        sb.append("    newRestrictionValue: ").append(this.toIndentedString(this.newRestrictionValue)).append("\n");
        sb.append("    newRestrictionType: ").append(this.toIndentedString((Object)this.newRestrictionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

