/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.AliasActionEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to link a namespace to a mosaic.")
public class MosaicAliasTransactionDTO {
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @SerializedName(value="signerPublicKey")
    private String signerPublicKey;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Integer type;
    public static final String SERIALIZED_NAME_MAX_FEE = "maxFee";
    @SerializedName(value="maxFee")
    private BigInteger maxFee = null;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private BigInteger deadline = null;
    public static final String SERIALIZED_NAME_ALIAS_ACTION = "aliasAction";
    @SerializedName(value="aliasAction")
    private AliasActionEnum aliasAction;
    public static final String SERIALIZED_NAME_NAMESPACE_ID = "namespaceId";
    @SerializedName(value="namespaceId")
    private String namespaceId;
    public static final String SERIALIZED_NAME_MOSAIC_ID = "mosaicId";
    @SerializedName(value="mosaicId")
    private String mosaicId;

    public MosaicAliasTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public MosaicAliasTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public MosaicAliasTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="36867", required=true, value="Entity version. The higher byte represents the network identifier: * 0x68 (MAIN_NET) - Public main network. * 0x98 (TEST_NET) - Public test network. * 0x60 (MIJIN) - Private network. * 0x90 (MIJIN_TEST) - Private test network. ")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MosaicAliasTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public MosaicAliasTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public MosaicAliasTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public MosaicAliasTransactionDTO aliasAction(AliasActionEnum aliasAction) {
        this.aliasAction = aliasAction;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AliasActionEnum getAliasAction() {
        return this.aliasAction;
    }

    public void setAliasAction(AliasActionEnum aliasAction) {
        this.aliasAction = aliasAction;
    }

    public MosaicAliasTransactionDTO namespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Namespace identifier.")
    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public MosaicAliasTransactionDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicAliasTransactionDTO mosaicAliasTransactionDTO = (MosaicAliasTransactionDTO)o;
        return Objects.equals(this.signature, mosaicAliasTransactionDTO.signature) && Objects.equals(this.signerPublicKey, mosaicAliasTransactionDTO.signerPublicKey) && Objects.equals(this.version, mosaicAliasTransactionDTO.version) && Objects.equals(this.type, mosaicAliasTransactionDTO.type) && Objects.equals(this.maxFee, mosaicAliasTransactionDTO.maxFee) && Objects.equals(this.deadline, mosaicAliasTransactionDTO.deadline) && Objects.equals((Object)this.aliasAction, (Object)mosaicAliasTransactionDTO.aliasAction) && Objects.equals(this.namespaceId, mosaicAliasTransactionDTO.namespaceId) && Objects.equals(this.mosaicId, mosaicAliasTransactionDTO.mosaicId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.type, this.maxFee, this.deadline, this.aliasAction, this.namespaceId, this.mosaicId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicAliasTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    aliasAction: ").append(this.toIndentedString((Object)this.aliasAction)).append("\n");
        sb.append("    namespaceId: ").append(this.toIndentedString(this.namespaceId)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

