/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.model;

import com.google.gson.annotations.SerializedName;
import io.nem.sdk.openapi.okhttp_gson.model.ReceiptTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Invisible state change that triggered a mosaic transfer.")
public class BalanceTransferReceiptDTO {
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private ReceiptTypeEnum type;
    public static final String SERIALIZED_NAME_SENDER_PUBLIC_KEY = "senderPublicKey";
    @SerializedName(value="senderPublicKey")
    private String senderPublicKey;
    public static final String SERIALIZED_NAME_RECIPIENT_ADDRESS = "recipientAddress";
    @SerializedName(value="recipientAddress")
    private String recipientAddress;
    public static final String SERIALIZED_NAME_MOSAIC_ID = "mosaicId";
    @SerializedName(value="mosaicId")
    private String mosaicId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigInteger amount = null;

    public BalanceTransferReceiptDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Version of the receipt.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BalanceTransferReceiptDTO type(ReceiptTypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ReceiptTypeEnum getType() {
        return this.type;
    }

    public void setType(ReceiptTypeEnum type) {
        this.type = type;
    }

    public BalanceTransferReceiptDTO senderPublicKey(String senderPublicKey) {
        this.senderPublicKey = senderPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSenderPublicKey() {
        return this.senderPublicKey;
    }

    public void setSenderPublicKey(String senderPublicKey) {
        this.senderPublicKey = senderPublicKey;
    }

    public BalanceTransferReceiptDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Decoded address.")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public BalanceTransferReceiptDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public BalanceTransferReceiptDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTransferReceiptDTO balanceTransferReceiptDTO = (BalanceTransferReceiptDTO)o;
        return Objects.equals(this.version, balanceTransferReceiptDTO.version) && Objects.equals((Object)this.type, (Object)balanceTransferReceiptDTO.type) && Objects.equals(this.senderPublicKey, balanceTransferReceiptDTO.senderPublicKey) && Objects.equals(this.recipientAddress, balanceTransferReceiptDTO.recipientAddress) && Objects.equals(this.mosaicId, balanceTransferReceiptDTO.mosaicId) && Objects.equals(this.amount, balanceTransferReceiptDTO.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.type, this.senderPublicKey, this.recipientAddress, this.mosaicId, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceTransferReceiptDTO {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    senderPublicKey: ").append(this.toIndentedString(this.senderPublicKey)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

