/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.api;

import com.google.gson.reflect.TypeToken;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceIds;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceNameDTO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class NamespaceRoutesApi {
    private ApiClient localVarApiClient;

    public NamespaceRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NamespaceRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getNamespaceCall(String namespaceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/namespace/{namespaceId}".replaceAll("\\{namespaceId\\}", this.localVarApiClient.escapeString(namespaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespaceValidateBeforeCall(String namespaceId, ApiCallback _callback) throws ApiException {
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespace(Async)");
        }
        Call localVarCall = this.getNamespaceCall(namespaceId, _callback);
        return localVarCall;
    }

    public NamespaceInfoDTO getNamespace(String namespaceId) throws ApiException {
        ApiResponse<NamespaceInfoDTO> localVarResp = this.getNamespaceWithHttpInfo(namespaceId);
        return localVarResp.getData();
    }

    public ApiResponse<NamespaceInfoDTO> getNamespaceWithHttpInfo(String namespaceId) throws ApiException {
        Call localVarCall = this.getNamespaceValidateBeforeCall(namespaceId, null);
        Type localVarReturnType = new TypeToken<NamespaceInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespaceAsync(String namespaceId, ApiCallback<NamespaceInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getNamespaceValidateBeforeCall(namespaceId, _callback);
        Type localVarReturnType = new TypeToken<NamespaceInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespacesFromAccountCall(String accountId, Integer pageSize, String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/namespaces".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacesFromAccountValidateBeforeCall(String accountId, Integer pageSize, String id, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getNamespacesFromAccount(Async)");
        }
        Call localVarCall = this.getNamespacesFromAccountCall(accountId, pageSize, id, _callback);
        return localVarCall;
    }

    public List<NamespaceInfoDTO> getNamespacesFromAccount(String accountId, Integer pageSize, String id) throws ApiException {
        ApiResponse<List<NamespaceInfoDTO>> localVarResp = this.getNamespacesFromAccountWithHttpInfo(accountId, pageSize, id);
        return localVarResp.getData();
    }

    public ApiResponse<List<NamespaceInfoDTO>> getNamespacesFromAccountWithHttpInfo(String accountId, Integer pageSize, String id) throws ApiException {
        Call localVarCall = this.getNamespacesFromAccountValidateBeforeCall(accountId, pageSize, id, null);
        Type localVarReturnType = new TypeToken<List<NamespaceInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespacesFromAccountAsync(String accountId, Integer pageSize, String id, ApiCallback<List<NamespaceInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getNamespacesFromAccountValidateBeforeCall(accountId, pageSize, id, _callback);
        Type localVarReturnType = new TypeToken<List<NamespaceInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespacesFromAccountsCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account/namespaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacesFromAccountsValidateBeforeCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getNamespacesFromAccountsCall(accountIds, _callback);
        return localVarCall;
    }

    public List<NamespaceInfoDTO> getNamespacesFromAccounts(AccountIds accountIds) throws ApiException {
        ApiResponse<List<NamespaceInfoDTO>> localVarResp = this.getNamespacesFromAccountsWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    public ApiResponse<List<NamespaceInfoDTO>> getNamespacesFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
        Call localVarCall = this.getNamespacesFromAccountsValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<List<NamespaceInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespacesFromAccountsAsync(AccountIds accountIds, ApiCallback<List<NamespaceInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getNamespacesFromAccountsValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<List<NamespaceInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespacesNamesCall(NamespaceIds namespaceIds, ApiCallback _callback) throws ApiException {
        NamespaceIds localVarPostBody = namespaceIds;
        String localVarPath = "/namespace/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespacesNamesValidateBeforeCall(NamespaceIds namespaceIds, ApiCallback _callback) throws ApiException {
        if (namespaceIds == null) {
            throw new ApiException("Missing the required parameter 'namespaceIds' when calling getNamespacesNames(Async)");
        }
        Call localVarCall = this.getNamespacesNamesCall(namespaceIds, _callback);
        return localVarCall;
    }

    public List<NamespaceNameDTO> getNamespacesNames(NamespaceIds namespaceIds) throws ApiException {
        ApiResponse<List<NamespaceNameDTO>> localVarResp = this.getNamespacesNamesWithHttpInfo(namespaceIds);
        return localVarResp.getData();
    }

    public ApiResponse<List<NamespaceNameDTO>> getNamespacesNamesWithHttpInfo(NamespaceIds namespaceIds) throws ApiException {
        Call localVarCall = this.getNamespacesNamesValidateBeforeCall(namespaceIds, null);
        Type localVarReturnType = new TypeToken<List<NamespaceNameDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespacesNamesAsync(NamespaceIds namespaceIds, ApiCallback<List<NamespaceNameDTO>> _callback) throws ApiException {
        Call localVarCall = this.getNamespacesNamesValidateBeforeCall(namespaceIds, _callback);
        Type localVarReturnType = new TypeToken<List<NamespaceNameDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

