/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.api;

import com.google.gson.reflect.TypeToken;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicIds;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicsNamesDTO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class MosaicRoutesApi {
    private ApiClient localVarApiClient;

    public MosaicRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MosaicRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getMosaicCall(String mosaicId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/mosaic/{mosaicId}".replaceAll("\\{mosaicId\\}", this.localVarApiClient.escapeString(mosaicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMosaicValidateBeforeCall(String mosaicId, ApiCallback _callback) throws ApiException {
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaic(Async)");
        }
        Call localVarCall = this.getMosaicCall(mosaicId, _callback);
        return localVarCall;
    }

    public MosaicInfoDTO getMosaic(String mosaicId) throws ApiException {
        ApiResponse<MosaicInfoDTO> localVarResp = this.getMosaicWithHttpInfo(mosaicId);
        return localVarResp.getData();
    }

    public ApiResponse<MosaicInfoDTO> getMosaicWithHttpInfo(String mosaicId) throws ApiException {
        Call localVarCall = this.getMosaicValidateBeforeCall(mosaicId, null);
        Type localVarReturnType = new TypeToken<MosaicInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMosaicAsync(String mosaicId, ApiCallback<MosaicInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getMosaicValidateBeforeCall(mosaicId, _callback);
        Type localVarReturnType = new TypeToken<MosaicInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMosaicsCall(MosaicIds mosaicIds, ApiCallback _callback) throws ApiException {
        MosaicIds localVarPostBody = mosaicIds;
        String localVarPath = "/mosaic";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMosaicsValidateBeforeCall(MosaicIds mosaicIds, ApiCallback _callback) throws ApiException {
        if (mosaicIds == null) {
            throw new ApiException("Missing the required parameter 'mosaicIds' when calling getMosaics(Async)");
        }
        Call localVarCall = this.getMosaicsCall(mosaicIds, _callback);
        return localVarCall;
    }

    public List<MosaicInfoDTO> getMosaics(MosaicIds mosaicIds) throws ApiException {
        ApiResponse<List<MosaicInfoDTO>> localVarResp = this.getMosaicsWithHttpInfo(mosaicIds);
        return localVarResp.getData();
    }

    public ApiResponse<List<MosaicInfoDTO>> getMosaicsWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        Call localVarCall = this.getMosaicsValidateBeforeCall(mosaicIds, null);
        Type localVarReturnType = new TypeToken<List<MosaicInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMosaicsAsync(MosaicIds mosaicIds, ApiCallback<List<MosaicInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getMosaicsValidateBeforeCall(mosaicIds, _callback);
        Type localVarReturnType = new TypeToken<List<MosaicInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMosaicsNamesCall(MosaicIds mosaicIds, ApiCallback _callback) throws ApiException {
        MosaicIds localVarPostBody = mosaicIds;
        String localVarPath = "/mosaic/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMosaicsNamesValidateBeforeCall(MosaicIds mosaicIds, ApiCallback _callback) throws ApiException {
        if (mosaicIds == null) {
            throw new ApiException("Missing the required parameter 'mosaicIds' when calling getMosaicsNames(Async)");
        }
        Call localVarCall = this.getMosaicsNamesCall(mosaicIds, _callback);
        return localVarCall;
    }

    public MosaicsNamesDTO getMosaicsNames(MosaicIds mosaicIds) throws ApiException {
        ApiResponse<MosaicsNamesDTO> localVarResp = this.getMosaicsNamesWithHttpInfo(mosaicIds);
        return localVarResp.getData();
    }

    public ApiResponse<MosaicsNamesDTO> getMosaicsNamesWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        Call localVarCall = this.getMosaicsNamesValidateBeforeCall(mosaicIds, null);
        Type localVarReturnType = new TypeToken<MosaicsNamesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMosaicsNamesAsync(MosaicIds mosaicIds, ApiCallback<MosaicsNamesDTO> _callback) throws ApiException {
        Call localVarCall = this.getMosaicsNamesValidateBeforeCall(mosaicIds, _callback);
        Type localVarReturnType = new TypeToken<MosaicsNamesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

